#include "main-screen.hpp"

#include "../vulkan-game.hpp"

#include "button.hpp"

MainScreen::MainScreen(SDL_Renderer& renderer, VulkanGame& gameInfo) :
      Screen(renderer, gameInfo) {
   addUIElement(new Button("New Game", 368, 131, 9, 0x222299FF, 0xFFFFFFFF, this->gameInfo,
      this->renderer, newGame_onMouseClick, nullptr, nullptr));
   addUIElement(new Button("Quit", 382, 186, 9, 0x222299FF, 0xFFFFFFFF, this->gameInfo,
      this->renderer, quit_onMouseClick, nullptr, nullptr));
}

MainScreen::~MainScreen() {
}

void MainScreen::createRenderCommands(VkCommandBuffer& commandBuffer, uint32_t currentImage) {
   // Always render this pipeline last
   gameInfo.overlayPipeline.createRenderCommands(commandBuffer, currentImage);
}

void MainScreen::handleEvent(GameEvent& e) {
   Screen::handleEvent(e);
}

void newGame_onMouseClick(VulkanGame& gameInfo) {
   gameInfo.goToScreen(gameInfo.screens[SCREEN_GAME]);
}

void quit_onMouseClick(VulkanGame& gameInfo) {
   gameInfo.quitGame();
}
