#ifndef _GAME_GUI_SDL_H
#define _GAME_GUI_SDL_H

#include "game-gui.hpp"

#include <SDL2/SDL.h>
#include <SDL2/SDL_image.h>
#include <SDL2/SDL_ttf.h>
#include <SDL2/SDL_vulkan.h>

class GameGui_SDL : public GameGui {
   public:
      string& getError();

      bool init();
      void shutdown();

      void* createWindow(const string& title, int width, int height, bool fullscreen);
      void destroyWindow();

      void processEvents();
      int pollEvent(UIEvent* event);

      // temporary
      //int pollEvent(SDL_Event* event);

      /*
      void processEvents();

      unsigned char getKeyEvent(unsigned int key);
      bool isKeyPressed(unsigned int key);

      int pollMouseEvent(MouseEvent* event);
      */

#ifdef GAMEGUI_INCLUDE_VULKAN
      bool createVulkanSurface(VkInstance instance, VkSurfaceKHR* surface);
#endif

      vector<const char*> getRequiredExtensions();
      void getWindowSize(int* width, int* height);

   private:
      SDL_Window* window;

      static string s_errorMessage;
};

#endif // _GAME_GUI_SDL_H