#include "vulkan-game.hpp"

#include <iostream>

#include "consts.hpp"

using namespace std;

VulkanGame::VulkanGame() {
   gui = nullptr;
   window = nullptr;
}

VulkanGame::~VulkanGame() {
}

void VulkanGame::run(int width, int height, unsigned char guiFlags) {
   if (initWindow(width, height, guiFlags) == RTWO_ERROR) {
      return;
   }

   SDL_Renderer* renderer = SDL_CreateRenderer(window, -1, 0);
   SDL_SetRenderDrawColor(renderer, 0, 0, 0, 255);

   SDL_RenderClear(renderer);

   SDL_RenderPresent(renderer);

   initVulkan();
   mainLoop();
   cleanup();
}

bool VulkanGame::initWindow(int width, int height, unsigned char guiFlags) {
   gui = new GameGui_SDL();

   if (gui->init() == RTWO_ERROR) {
      cout << "UI library could not be initialized!" << endl;
      cout << gui->getError() << endl;
      return RTWO_ERROR;
   }

   window = (SDL_Window*) gui->createWindow("Vulkan Game", width, height, guiFlags & GUI_FLAGS_WINDOW_FULLSCREEN);
   if (window == nullptr) {
      cout << "Window could not be created!" << endl;
      cout << gui->getError() << endl;
      return RTWO_ERROR;
   }

   int actualWidth, actualHeight;
   gui->getWindowSize(&actualWidth, &actualHeight);

   cout << "Target window size: (" << width << ", " << height << ")" << endl;
   cout << "Actual window size: (" << actualWidth << ", " << actualHeight << ")" << endl;

   return RTWO_SUCCESS;
}

void VulkanGame::initVulkan() {
}

void VulkanGame::mainLoop() {
   UIEvent e;
   bool quit = false;

   while (!quit) {
      gui->processEvents();

      while (gui->pollEvent(&e)) {
         switch(e.type) {
            case UI_EVENT_QUIT:
               cout << "Quit event detected" << endl;
               quit = true;
               break;
            case UI_EVENT_WINDOW:
               cout << "Window event detected" << endl;
               // Currently unused
               break;
            case UI_EVENT_KEY:
               if (e.key.keycode == SDL_SCANCODE_ESCAPE) {
                  quit = true;
               } else {
                  cout << "Key event detected" << endl;
               }
               break;
            case UI_EVENT_MOUSEBUTTONDOWN:
               cout << "Mouse button down event detected" << endl;
               break;
            case UI_EVENT_MOUSEBUTTONUP:
               cout << "Mouse button up event detected" << endl;
               break;
            case UI_EVENT_MOUSEMOTION:
               break;
         }
      }
   }
}

void VulkanGame::cleanup() {
   gui->destroyWindow();
   gui->shutdown();
   delete gui;
}