#ifndef _GAME_GUI_GLFW_H
#define _GAME_GUI_GLFW_H

#include <queue>

#include "game-gui.hpp"

#ifdef GAMEGUI_INCLUDE_VULKAN
   #define GLFW_INCLUDE_VULKAN
#else
   #include <GL/glew.h>
#endif

#include <GLFW/glfw3.h>

class GameGui_GLFW : public GameGui {
   public:
      static string s_errorMessage; // Has to be public so that glfw_error_callback can access it

      // Has to be public so that glfw_key_callback can access it
      static queue<UIEvent> s_events;

      string& getError();

      bool init();
      void shutdown();

      void* createWindow(const string& title, int width, int height, bool fullscreen);
      void destroyWindow();

      void bindEventHandlers();
      void processEvents();
      int pollEvent(UIEvent* event);

      void refreshWindowSize();
      int getWindowWidth();
      int getWindowHeight();

#ifdef GAMEGUI_INCLUDE_VULKAN
      bool createVulkanSurface(VkInstance instance, VkSurfaceKHR* surface);
      vector<const char*> getRequiredExtensions();
#endif

   private:
      GLFWwindow* window;
      int windowWidth, windowHeight;
};

void glfw_error_callback(int error, const char* description);
void glfw_mouse_button_callback(GLFWwindow* window, int button, int action, int mods);
void glfw_key_callback(GLFWwindow* window, int key, int scancode, int action, int mods);

#endif // _GAME_GUI_GLFW_H