import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;

/*
 * This is the main class in the portal project and it creates the gui and starts the thread that handles server communication.
 */

public class LostHavenPortal extends JFrame {
	private static final long serialVersionUID = 1L;
	
	public HashMap<String, Player> registered;
	public PriorityQueue<String> orderedReg;
	public PriorityQueue<String> orderedOnline;
	
	public JLabel lblConnectionStatus;
	public JLabel lblServerStatus;
	private JButton btnConnect;
	private JButton btnDisconnect;
	private JButton btnStart;
	private JButton btnStop;
	private JList lstRegistered;
	private JList lstOnline;
	private PortalThread thread;
	
	public LostHavenPortal() {
		registered = new HashMap<String, Player>();
		orderedReg = new PriorityQueue<String>(11, new PlayerComparator());
		orderedOnline = new PriorityQueue<String>(11, new PlayerComparator());
		
		MyWindowListener wndListener = new MyWindowListener();
		MyButtonListener btnListener = new MyButtonListener();
		
        addWindowListener(wndListener);
        setLayout(new FlowLayout());
        
        lblConnectionStatus = new JLabel("disconnected");
        lblServerStatus = new JLabel("not available");
        
        btnConnect = new JButton("connect");
        btnConnect.addActionListener(btnListener);
        btnDisconnect = new JButton("disconnect");
        btnDisconnect.addActionListener(btnListener);
        btnStart = new JButton("start");
        btnStart.addActionListener(btnListener);
        btnStop = new JButton("stop");
        btnStop.addActionListener(btnListener);
        
        lstRegistered = new JList();
        lstOnline = new JList();
        
        add(lblConnectionStatus);
        add(lblServerStatus);
        add(btnConnect);
        add(btnDisconnect);
        add(btnStart);
        add(btnStop);
        add(lstRegistered);
        add(lstOnline);
        
		setSize(600, 400);
		setVisible(true);
	}
	
	public void addRegList(String str, Player player) {
		registered.put(str, player);
		orderedReg.add(str);
		updateGui();
	}
	
	public void addOnlineList(String str) {
		orderedOnline.add(str);
		updateGui();
	}
	
	public void updateGui() {
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				lstRegistered.setListData(orderedReg.toArray());
				lstOnline.setListData(orderedOnline.toArray());
			}
		});
	}
	
	private void start() {
		if(!Connection.isConnected(thread)) {
			//thread = new PortalThread("64.9.205.76", 5829, this);
			//thread = new PortalThread("69.138.160.41", 5829, this);
			thread = new PortalThread("127.0.0.1", 5829, this);
			thread.start();
		}else {
			JOptionPane.showMessageDialog(this, "Connection has already been established.");
		}
	}
	
	private void stop() {
		if(Connection.isConnected(thread)) {
			thread.closeConnection();
		}else {
			JOptionPane.showMessageDialog(this, "Connection has not yet been established.");
		}
	}
	
	private class MyWindowListener extends WindowAdapter {
		public void windowClosing(WindowEvent e) {
			if(thread != null)
				thread.closeConnection();
			System.exit(0);
	    }
	}
	
	private class MyButtonListener implements ActionListener {
		public void actionPerformed(ActionEvent e) {
			String str = ((JButton)e.getSource()).getText();
	        
			if(str.equals("connect")){
				start();
			}else if(str.equals("disconnect")){
				stop();
			}else if(str.equals("start")){
				if(Connection.isConnected(thread))
					thread.sendMessage(MessageType.StartServer, "");
			}else if(str.equals("stop")){
				if(Connection.isConnected(thread))
					thread.sendMessage(MessageType.StopServer, "");
			}
	    }
	}
	
	public static void main(String[] args) {
        new LostHavenPortal();
    }
	
	private class PlayerComparator implements Comparator<String> {
		public int compare(String str1, String str2) {
			return registered.get(str1).getId() - registered.get(str2).getId();
		}
	}
}
