package utils;

import java.awt.Rectangle;
import java.awt.Shape;
import collision.Bound;
import java.awt.geom.Ellipse2D;
import main.Enemy;
import java.util.ArrayList;
import main.Creature;
import java.util.HashMap;
import java.awt.Graphics2D;
import java.awt.image.BufferedImageOp;
import java.awt.Composite;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.image.ImageObserver;
import java.awt.Image;
import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.awt.FontFormatException;
import java.io.File;
import java.awt.Font;
import java.io.IOException;
import java.io.FileReader;
import java.io.Reader;
import java.io.InputStreamReader;
import java.io.BufferedReader;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.util.Date;
import java.text.SimpleDateFormat;
import main.Direction;
import java.awt.GraphicsConfiguration;

public class Utils
{
    private static boolean RUNNING_FROM_JAR;
    private static Utils classLoaderReference;
    public static GraphicsConfiguration gc;
    
    static {
        Utils.classLoaderReference = null;
    }
    
    public static void init(final GraphicsConfiguration gc, final boolean jar) {
        Utils.gc = gc;
        Utils.RUNNING_FROM_JAR = jar;
    }
    
    public static String shortString(final Direction dir) {
        switch (dir) {
            case North: {
                return "n";
            }
            case NorthEast: {
                return "ne";
            }
            case East: {
                return "e";
            }
            case SouthEast: {
                return "se";
            }
            case South: {
                return "s";
            }
            case SouthWest: {
                return "sw";
            }
            case West: {
                return "w";
            }
            case NorthWest: {
                return "nw";
            }
            default: {
                return "";
            }
        }
    }
    
    public static String dateString() {
        return new SimpleDateFormat("MM/dd/yyyy HH:mm:ss").format(new Date());
    }
    
    private static DisplayMode getBestDisplayMode(final GraphicsDevice device, final int xRes, final int yRes) {
        final DisplayMode[] BEST_DISPLAY_MODES = { new DisplayMode(xRes, yRes, 32, 0), new DisplayMode(xRes, yRes, 16, 0), new DisplayMode(xRes, yRes, 8, 0) };
        for (int x = 0; x < BEST_DISPLAY_MODES.length; ++x) {
            final DisplayMode[] modes = device.getDisplayModes();
            for (int i = 0; i < modes.length; ++i) {
                if (modes[i].getWidth() == BEST_DISPLAY_MODES[x].getWidth() && modes[i].getHeight() == BEST_DISPLAY_MODES[x].getHeight() && modes[i].getBitDepth() == BEST_DISPLAY_MODES[x].getBitDepth()) {
                    return BEST_DISPLAY_MODES[x];
                }
            }
        }
        return null;
    }
    
    public static void chooseBestDisplayMode(final GraphicsDevice device, final int xRes, final int yRes) {
        final DisplayMode best = getBestDisplayMode(device, xRes, yRes);
        if (best != null) {
            device.setDisplayMode(best);
        }
    }
    
    public static BufferedReader loadTextFile(final String fileName) throws IOException {
        if (Utils.RUNNING_FROM_JAR) {
            if (Utils.classLoaderReference == null) {
                Utils.classLoaderReference = new Utils();
            }
            return new BufferedReader(new InputStreamReader(Utils.classLoaderReference.getClass().getResourceAsStream("/" + fileName)));
        }
        return new BufferedReader(new FileReader(fileName));
    }
    
    public static Font loadFont(final String fileName) {
        try {
            if (Utils.RUNNING_FROM_JAR) {
                if (Utils.classLoaderReference == null) {
                    Utils.classLoaderReference = new Utils();
                }
                return Font.createFont(0, Utils.classLoaderReference.getClass().getResourceAsStream("/" + fileName));
            }
            return Font.createFont(0, new File(fileName));
        }
        catch (FontFormatException ffe) {
            ffe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return null;
    }
    
    public static BufferedImage loadImg(final String fileName) {
        try {
            BufferedImage init;
            if (Utils.RUNNING_FROM_JAR) {
                if (Utils.classLoaderReference == null) {
                    Utils.classLoaderReference = new Utils();
                }
                init = ImageIO.read(Utils.classLoaderReference.getClass().getResource("/images/" + fileName));
            } else {
                init = ImageIO.read(new File("images/" + fileName));
            }
            final BufferedImage accelerated = Utils.gc.createCompatibleImage(init.getWidth(), init.getHeight(), 3);
            accelerated.getGraphics().drawImage(init, 0, 0, null);
            return accelerated;
        } catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }
    
    public static BufferedImage loadTransImg(final String fileName, final Color bgColor, final Color shadowColor) {
        try {
            BufferedImage init;
            if (Utils.RUNNING_FROM_JAR) {
                init = ImageIO.read(Utils.classLoaderReference.getClass().getResource("/images/" + fileName));
            }
            else {
                init = ImageIO.read(new File("images/" + fileName));
            }
            init = makeColorTransparent(init, bgColor, 0);
            init = makeColorTransparent(init, shadowColor, -1593835520);
            final BufferedImage accelerated = Utils.gc.createCompatibleImage(init.getWidth(), init.getHeight(), 3);
            accelerated.getGraphics().drawImage(init, 0, 0, null);
            return accelerated;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }
    
    public static BufferedImage makeColorTransparent(final BufferedImage image, final Color color, final int newColor) {
        final BufferedImage dimg = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        final Graphics2D g = dimg.createGraphics();
        g.setComposite(AlphaComposite.Src);
        g.drawImage(image, null, 0, 0);
        g.dispose();
        for (int i = 0; i < dimg.getHeight(); ++i) {
            for (int j = 0; j < dimg.getWidth(); ++j) {
                if (dimg.getRGB(j, i) == color.getRGB()) {
                    dimg.setRGB(j, i, newColor);
                }
            }
        }
        return dimg;
    }
    
    public static void loadCreatures(final HashMap<Integer, Creature> crMap, final ArrayList<Creature> crSet) {
        final int[][] numFramesArr = { { 8, 1, 13, 9, 9 }, { 9, 1, 9, 7, 9 }, { 8, 1, 13, 9, 11 }, { 9, 1, 13, 7, 9 }, { 8, 1, 9, 7, 11 }, { 8, 1, 13, 9, 13 }, { 8, 1, 13, 9, 13 } };
        Enemy cr = new Enemy("Black Guard", 0, 22, 400);
        cr.loadModel("black-knight", new Color(111, 79, 51), new Color(41, 29, 18), numFramesArr[0]);
        cr.setBound(new Bound(new Ellipse2D.Double(-16.0, -16.0, 32.0, 32.0)));
        cr.setSelectionBound(new Bound(new Rectangle(-20, -53, 40, 63)));
        cr.strikeFrame = 9;
        cr.spotRadius = 240;
        cr.patrolRadius = 400;
        cr.setAttack(10, 0, 32, 60);
        cr.setStats(0, 0, 10, 10);
        if (crSet != null) {
            crSet.add(cr);
        }
        crMap.put(cr.id, cr);
        cr = new Enemy("Rogue", 0, 30, 300);
        cr.loadModel("burra", new Color(106, 76, 48), new Color(39, 27, 17), numFramesArr[1]);
        cr.setBound(new Bound(new Ellipse2D.Double(-13.0, -13.0, 26.0, 26.0)));
        cr.setSelectionBound(new Bound(new Rectangle(-16, -50, 32, 60)));
        cr.strikeFrame = 6;
        cr.spotRadius = 300;
        cr.patrolRadius = 500;
        cr.setAttack(5, 0, 32, 60);
        cr.setStats(0, 0, 7, 7);
        if (crSet != null) {
            crSet.add(cr);
        }
        crMap.put(cr.id, cr);
        cr = new Enemy("Ninja", 0, 22, 500);
        cr.loadModel("black-ninja", new Color(106, 76, 48), new Color(39, 27, 17), numFramesArr[2]);
        cr.setBound(new Bound(new Ellipse2D.Double(-13.0, -13.0, 26.0, 26.0)));
        cr.setSelectionBound(new Bound(new Rectangle(-16, -54, 32, 60)));
        cr.strikeFrame = 9;
        cr.spotRadius = 300;
        cr.patrolRadius = 500;
        cr.setAttack(20, 0, 32, 60);
        cr.setStats(0, 0, 15, 15);
        if (crSet != null) {
            crSet.add(cr);
        }
        crMap.put(cr.id, cr);
        cr = new Enemy("Ranger", 0, 30, 350);
        cr.loadModel("swordstan", new Color(106, 76, 48), new Color(39, 27, 17), numFramesArr[3]);
        cr.setBound(new Bound(new Ellipse2D.Double(-13.0, -13.0, 26.0, 26.0)));
        cr.setSelectionBound(new Bound(new Rectangle(-16, -47, 32, 57)));
        cr.strikeFrame = 9;
        cr.spotRadius = 450;
        cr.patrolRadius = 700;
        cr.setAttack(6, 0, 32, 60);
        cr.setStats(0, 0, 8, 8);
        if (crSet != null) {
            crSet.add(cr);
        }
        crMap.put(cr.id, cr);
        cr = new Enemy("White Dragon", 0, 52, 1000);
        cr.loadModel("airdragon", new Color(106, 76, 48), new Color(39, 27, 17), numFramesArr[4]);
        cr.setBound(new Bound(new Ellipse2D.Double(-20.0, -20.0, 40.0, 40.0)));
        cr.setSelectionBound(new Bound(new Rectangle(-24, -53, 48, 63)));
        cr.strikeFrame = 5;
        cr.spotRadius = 240;
        cr.patrolRadius = 400;
        cr.setAttack(50, 0, 45, 70);
        cr.setStats(0, 0, 120, 120);
        if (crSet != null) {
            crSet.add(cr);
        }
        crMap.put(cr.id, cr);
        cr = new Enemy("White Mage", 0, 30, 400);
        cr.loadModel("white-mage", new Color(105, 74, 46), new Color(33, 23, 14), numFramesArr[6]);
        cr.setBound(new Bound(new Ellipse2D.Double(-16.0, -16.0, 32.0, 32.0)));
        cr.setSelectionBound(new Bound(new Rectangle(-16, -47, 32, 57)));
        cr.strikeFrame = 9;
        cr.spotRadius = 240;
        cr.patrolRadius = 400;
        cr.setAttack(10, 0, 45, 70);
        cr.setStats(0, 0, 5, 5);
        if (crSet != null) {
            crSet.add(cr);
        }
        crMap.put(cr.id, cr);
        cr = new Enemy("Orc", 0, 22, 250);
        cr.loadModel("orc", new Color(105, 74, 46), new Color(33, 23, 14), numFramesArr[5]);
        cr.setBound(new Bound(new Ellipse2D.Double(-13.0, -13.0, 26.0, 26.0)));
        cr.setSelectionBound(new Bound(new Rectangle(-18, -57, 36, 67)));
        cr.strikeFrame = 9;
        cr.spotRadius = 240;
        cr.patrolRadius = 400;
        cr.setAttack(30, 0, 45, 70);
        cr.setStats(0, 0, 40, 40);
        if (crSet != null) {
            crSet.add(cr);
        }
        crMap.put(cr.id, cr);
    }
}
