package main;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.util.ArrayList;
import utils.DynamicImage;

public class Item extends MapObject
{
    private String name;
    private DynamicImage img;
    private ArrayList<Effect> effects;
    protected int extraLines;
    protected int imgWidth;
    protected int imgHeight;
    public int invX;
    public int invY;
    
    public Item(final String name, final DynamicImage img, final int imgWidth, final int imgHeight) {
        super(0, 0, 0);
        this.name = name;
        this.img = img;
        this.effects = new ArrayList<Effect>();
        this.extraLines = 0;
        this.imgWidth = imgWidth;
        this.imgHeight = imgHeight;
        final boolean b = false;
        this.invY = (b ? 1 : 0);
        this.invX = (b ? 1 : 0);
    }
    
    protected Item(final Item o, final int x, final int y, final int z) {
        super(x, y, z);
        this.name = o.name;
        this.img = o.img;
        this.effects = o.effects;
        this.extraLines = o.extraLines;
        this.imgWidth = o.imgWidth;
        this.imgHeight = o.imgHeight;
        final boolean b = false;
        this.invY = (b ? 1 : 0);
        this.invX = (b ? 1 : 0);
    }
    
    public Item copy(final Point newLoc) {
        return new Item(this, newLoc.x, newLoc.y, 0);
    }
    
    public String getName() {
        return this.name;
    }
    
    @Override
    public double getSortZ() {
        return super.getSortZ() + 0.5;
    }
    
    public DynamicImage getImg() {
        return this.img;
    }
    
    public int getImgWidth() {
        return this.imgWidth;
    }
    
    public int getImgHeight() {
        return this.imgHeight;
    }
    
    public ArrayList<Effect> getEffects() {
        return this.effects;
    }
    
    public void addEffect(final Effect e) {
        this.effects.add(e);
    }
    
    @Override
    public void draw(final Graphics g, final int playerX, final int playerY) {
        this.img.draw(g, this.loc.x + playerX, this.loc.y + playerY);
    }
    
    public void drawDesc(final Graphics g, int x, final int y, final Font f, final FontMetrics m) {
        final int width = 200;
        int height = m.getDescent() + m.getHeight() * (2 + this.effects.size() + this.extraLines);
        if (width > 800 - x) {
            x -= width;
        }
        if (this.effects.size() == 0) {
            height -= m.getHeight();
        }
        g.setFont(f);
        g.setColor(Color.black);
        g.fillRect(x, y, width, height);
        g.setColor(new Color(120, 120, 240));
        g.drawRect(x, y, width, height);
        g.drawString(this.name, x + (width - m.stringWidth(this.name)) / 2, y + m.getHeight());
        this.addInfo(g, x, y, width, f, m);
        for (int i = 0; i < this.effects.size(); ++i) {
            g.drawString(this.effects.get(i).getDesc(), x + (width - m.stringWidth(this.effects.get(i).getDesc())) / 2, y + (i + 3 + this.extraLines) * m.getHeight());
        }
    }
    
    public void addInfo(final Graphics g, final int x, final int y, final int width, final Font f, final FontMetrics m) {
    }
}
