ackage gamegui;

import java.awt.FontMetrics;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.Font;
import java.util.ArrayList;

public class RadioGroup extends Member {
    private ArrayList<RadioButton> buttons;
    private RadioButton selected;
    private String text;
    private Font font;
    
    public RadioGroup(final String newName, final int newX, final int newY, final int newWidth, final int newHeight, final String newText, final Font newFont) {
        super(newName, newX, newY, newWidth, newHeight);
        this.buttons = new ArrayList<RadioButton>();
        this.selected = null;
        this.text = newText;
        this.font = newFont;
    }
    
    @Override
    public boolean handleEvent(final MouseEvent e) {
        if (this.selected != null) {
            this.selected.clear();
        }
        for (int x = 0; x < this.buttons.size(); ++x) {
            if (this.buttons.get(x).isClicked(e.getX(), e.getY())) {
                (this.selected = this.buttons.get(x)).setSelected(true);
                return true;
            }
        }
        return false;
    }
    
    @Override
    public void draw(final Graphics g) {
        final FontMetrics metrics = g.getFontMetrics(this.font);
        g.setColor(Color.green);
        g.setFont(this.font);
        g.drawString(this.text, this.getX() - metrics.stringWidth(this.text) - 10, this.getY() + (this.getHeight() + metrics.getHeight()) / 2 - 2);
        for (int x = 0; x < this.buttons.size(); ++x) {
            this.buttons.get(x).draw(g);
        }
    }
    
    @Override
    public void clear() {
        for (int x = 0; x < this.buttons.size(); ++x) {
            this.buttons.get(x).clear();
        }
    }
    
    public void add(final RadioButton aButton) {
        this.buttons.add(aButton);
    }
    
    public RadioButton getButton(final String aName) {
        for (int x = 0; x < this.buttons.size(); ++x) {
            if (this.buttons.get(x).getName().equals(aName)) {
                return this.buttons.get(x);
            }
        }
        return null;
    }
    
    public String getSelected() {
        if (this.selected != null) {
            return this.selected.getName();
        }
        return "None";
    }
    
    public void setSelected(final String button) {
        this.clear();
        for (int x = 0; x < this.buttons.size(); ++x) {
            if (this.buttons.get(x).getName().equals(button)) {
                this.buttons.get(x).setSelected(true);
            }
        }
    }
}
