package com.medievaltech.game;

import android.graphics.Canvas;
import android.graphics.Point;

public class Map {
	private Tile[][] grid;
	
	public Map(int width, int height) {
		grid = new Tile[width][height];
	}
	
	public Map(Tile t, int width, int height) {
		grid = new Tile[width][height];
		
		for(int x=0; x<getWidth(); x++)
			for(int y=0; y<getHeight(); y++)
				grid[x][y] = new Tile(t, new Point(x, y));
	}
	
	public int getWidth() {
		return grid.length;
	}
	
	public int getHeight() {
		return grid[0].length;
	}
	
	public Tile getTile(int x, int y) {
		return grid[x][y];
	}
	
	public Tile getTile(Point point) {
		return grid[point.x][point.y];
	}
	
	public void setTile(int x, int y, Tile t) {
		grid[x][y] = t;
	}
	
	public void draw(Canvas c, int xStart, int yStart) {
		for(int x=0; x<getWidth(); x++)
			for(int y=0; y<getHeight(); y++)
				grid[x][y].draw(c, xStart+50*x, yStart+50*y);
	}
}
