#include "screen.hpp"

#include "../vulkan-game.hpp"

Screen::Screen(SDL_Renderer& renderer, VulkanGame& gameInfo) :
      renderer(renderer),
      gameInfo(gameInfo) {
}

Screen::~Screen() {
   for (UIElement*& uiElement : this->uiElements) {
      delete uiElement;
   }
}

void Screen::init() {
   for (UIElement*& uiElement : this->uiElements) {
      uiElement->init();
   }
}

void Screen::renderUI() {
   SDL_SetRenderDrawColor(&this->renderer, 0x00, 0x00, 0x00, 0x00);
   SDL_RenderClear(&this->renderer);

   for (UIElement*& uiElement : this->uiElements) {
      uiElement->render(0, 0);
   }
}

void Screen::handleEvent(UIEvent& e) {
   for (UIElement*& uiElement : this->uiElements) {
      uiElement->handleEvent(e);
   }
}

void Screen::addUIElement(UIElement* element) {
   this->uiElements.push_back(element);
}
