#ifndef _SCREEN_H
#define _SCREEN_H

#include <vector>

#include <vulkan/vulkan.h>

#include <SDL2/SDL.h>

#include "../consts.hpp"
//#include "../game-gui.hpp"

#include "ui-element.hpp"

using namespace std;

class VulkanGame;

template<class Type>
struct ValueReference {
   
};

// TODO: Add a function to create an SDL_Color from a uint32_t

// TODO: Maybe make this a subclass of UIElement
class Screen {
public:
   Screen(SDL_Renderer& renderer, VulkanGame& gameInfo);
   virtual ~Screen();

   virtual void createRenderCommands(VkCommandBuffer& commandBuffer, uint32_t currentImage) = 0;
   virtual void init();
   
   virtual void renderUI();
   virtual void handleEvent(UIEvent& e);
   void addUIElement(UIElement* element);

protected:
   SDL_Renderer& renderer;
   VulkanGame& gameInfo;

private:
   vector<UIElement*> uiElements;
};

// TODO: Maybe move these somewhere else
void button_onMouseEnter(UIElement& element);
void button_onMouseLeave(UIElement& element);

#endif // _SCREEN_H
