#ifndef _UI_ELEMENT_HPP
#define _UI_ELEMENT_HPP

#include <SDL2/SDL.h>

#include "../game-gui.hpp"

class VulkanGame;

class UIElement {
public:
   UIElement(int x, int y, int width, int height, SDL_Renderer& renderer,
      void (*onMouseClick)(VulkanGame& gameInfo),
      void (*onMouseEnter)(UIElement& element),
      void (*onMouseLeave)(UIElement& element));
   virtual ~UIElement();

   virtual void init();
   virtual void render(int x, int y) = 0;
   virtual void handleEvent(UIEvent& e);

protected:
   int x, y;
   int width, height;
   SDL_Renderer& renderer;
   void (*onMouseClick)(VulkanGame& gameInfo);
   void (*onMouseEnter)(UIElement& element);
   void (*onMouseLeave)(UIElement& element);
};

#endif // _UI_ELEMENT_HPP
