#ifndef _BUTTON_HPP
#define _BUTTON_HPP

#include <string>

#include <SDL2/SDL.h>

#include "../game-gui.hpp"

#include "ui-element.hpp"

class Button : public UIElement {
public:
   Button(string label, int x, int y, int padding, uint32_t color, uint32_t textColor,
      VulkanGame& gameInfo, SDL_Renderer& renderer,
      void (*onMouseClick)(VulkanGame& gameInfo),
      void (*onMouseEnter)(UIElement& element),
      void (*onMouseLeave)(UIElement& element));
   ~Button() override;

   void init() override;
   void render(int x, int y) override;
   void handleEvent(UIEvent& e) override;

private:
   int labelWidth, labelHeight;
   uint32_t color, focusColor;
   bool focused;
   SDL_Texture* labelTexture = nullptr;
   VulkanGame& gameInfo;
};

#endif // _BUTTON_HPP
