#version 410

uniform mat4 model, view, proj;

layout (std140) uniform shader_data {
  mat4 model_mat;
};

layout(location = 0) in vec3 vertex_position;
layout(location = 1) in vec3 vertex_color;
layout(location = 2) in vec3 vertex_normal;

out vec3 position_eye, normal_eye, color, light_position_eye;

// fixed point light position
vec3 light_position_world = vec3(0.0, 0.0, 2.0);

void main() {
  position_eye = vec3(view * model * vec4(vertex_position, 1.0));
  normal_eye = vec3(view * model * vec4 (vertex_normal, 0.0));
  color = vertex_color;
  light_position_eye = vec3(view * vec4(light_position_world, 1.0));

  gl_Position = proj * vec4(position_eye, 1.0);
}
