package com.example.advancewars;

import com.example.advancewars.R;
import com.example.advancewars.GameView;
import com.example.advancewars.GameView.DrawingThread;
import android.app.Activity;
import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.Window;
import android.widget.TextView;
import java.io.*;

public class Game extends Activity {
    private static final int MENU_EXIT = 1;
    private static final int MENU_NEW = 2;
    
    public enum State{BUST, ACTIVE, DOUBLEDOWN};

    /** A handle to the thread that's actually running the animation. */
    public DrawingThread mThread;

    /** A handle to the View in which the game is running. */
    private GameView mGameView;
    
    /**
     * Invoked during init to give the Activity a chance to set up its Menu.
     * 
     * @param menu the Menu to which entries may be added
     * @return true
     */
    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        super.onCreateOptionsMenu(menu);

        menu.add(0, MENU_EXIT, 0, R.string.menu_exit);
        return true;
    }

    /**
     * Invoked when the user selects an item from the Menu.
     * 
     * @param item the Menu entry which was selected
     * @return true if the Menu item was legit (and we consumed it), false
     *         otherwise
     */
    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case MENU_EXIT:
            	this.finish();
            	break;
            case MENU_NEW:
            	break;
        }

        return true;
    }

    /**
     * Invoked when the Activity is created.
     * 
     * @param savedInstanceState a Bundle containing state saved from a previous
     *        execution, or null if this is a new execution
     */
    @Override
    protected void onCreate(Bundle savedInstanceState) {
    	Log.w("Blackjack", "We're inside onCreate");
    	
        super.onCreate(savedInstanceState);
        
        Log.w("Blackjack", "the super constructor was called successfully");

        // turn off the window's title bar
        requestWindowFeature(Window.FEATURE_NO_TITLE);

        // tell system to use the layout defined in our XML file
        setContentView(R.layout.main);

        mGameView = (GameView) findViewById(R.id.lunar);
        mThread = mGameView.getThread();

        mGameView.setTextView((TextView) findViewById(R.id.text));

        if (savedInstanceState == null) {	// we were just launched: set up a new game
        	Log.w("Blackjack", "SIS is null");
        	
        	mThread.setState(AppState.RUNNING);
        } else {
            Log.w("Blackjack", "SIS is nonnull");
            
            mThread.setState(AppState.RUNNING);
            
            mGameView.getThread().mGameState = (GameState)savedInstanceState.getSerializable("gameState");
            
		    mGameView.getThread().mPlayerWins = savedInstanceState.getInt("playerWins");
		    mGameView.getThread().mPlayerLosses = savedInstanceState.getInt("playerLosses");
        }
    }

    /**
     * Invoked when the Activity loses user focus.
     */
    @Override
    protected void onPause() {
        super.onPause();
        mGameView.getThread().pause(); // pause game when Activity pauses
    }

    /**
     * Notification that something is about to happen, to give the Activity a
     * chance to save state.
     * 
     * @param outState a Bundle into which this Activity should save its state
     */
    @Override
    protected void onSaveInstanceState(Bundle outState) {
    	outState.putSerializable("gameState", mGameView.getThread().mGameState);
	    outState.putSerializable("playerWins", mGameView.getThread().mPlayerWins);
	    outState.putSerializable("playerLosses", mGameView.getThread().mPlayerLosses);
	    
        super.onSaveInstanceState(outState);
        Log.w("Blackjack", "onSaveInstanceState called");
    }
    
    @Override
    protected void onStop() {
    	System.exit(1);
    	super.onStop();
    }
}