#version 410 core

uniform float elapsed_system_time;

layout (location = 0) in vec3 v_i; // initial velocity
layout (location = 1) in float start_time;

out float opacity;

void main() {
   float t = elapsed_system_time - start_time;
   t = mod(t, 3.0); // allow time to loop around so particle emitter keeps going

   vec3 p = vec3(0.0, 0.0, 0.0);
   vec3 a = vec3(0.0, -1.0, 0.0); // gravity
   p += v_i * t + 0.5 * a * t * t;

   opacity = 1.0 - (t / 3.0);

   gl_Position = vec4(p, 1.0);
   gl_PointSize = 15.0; // size in pixels
}
