#ifndef _GAME_GUI_GLFW_H
#define _GAME_GUI_GLFW_H

#include "game-gui.hpp"

#ifdef GAMEGUI_INCLUDE_VULKAN
   #define GLFW_INCLUDE_VULKAN
#endif

#include <GLFW/glfw3.h>

class GameGui_GLFW : public GameGui {
   public:
      string& GetError();

      static string s_errorMessage; // Has to be public so that glfw_error_callback can access it

      bool Init();
      void Shutdown();

      void* CreateWindow(const string& title, unsigned int width, unsigned int height);
      void DestroyWindow();

#ifdef GAMEGUI_INCLUDE_VULKAN
      bool CreateVulkanSurface(VkInstance instance, VkSurfaceKHR* surface);
#endif

      vector<const char*> GetRequiredExtensions();
      void GetWindowSize(int* width, int* height);

   private:
      GLFWwindow* window;
};

void glfw_error_callback(int error, const char* description);

#endif // _GAME_GUI_GLFW_H