#ifndef _GAME_GUI_SDL_H
#define _GAME_GUI_SDL_H

#include "game-gui.hpp"

#include <SDL2/SDL.h>
#include <SDL2/SDL_image.h>
#include <SDL2/SDL_ttf.h>
#include <SDL2/SDL_vulkan.h>

class GameGui_SDL : public GameGui {
   public:
      string& GetError();

      bool Init();
      void Shutdown();

      void* CreateWindow(const string& title, unsigned int width, unsigned int height);
      void DestroyWindow();

#ifdef GAMEGUI_INCLUDE_VULKAN
      bool CreateVulkanSurface(VkInstance instance, VkSurfaceKHR* surface);
#endif

      vector<const char*> GetRequiredExtensions();
      void GetWindowSize(int* width, int* height);

   private:
      SDL_Window* window;

      static string s_errorMessage;
};

#endif // _GAME_GUI_SDL_H