#version 450
#extension GL_ARB_separate_shader_objects : enable

layout(location = 0) in vec3 inPosition;
layout(location = 1) in vec3 inColor;
layout(location = 2) in vec2 inTexCoord;

layout(location = 0) out vec3 fragColor;
layout(location = 1) out vec2 fragTexCoord;
layout(location = 2) out uint isOverlay;

void main() {
   if (gl_VertexIndex < 0) {
      fragColor = inColor;
      isOverlay = 0;
   } else {
      fragColor = inColor;
      isOverlay = 1;
   }

   fragTexCoord = inTexCoord;
   gl_Position = vec4(inPosition, 1.0);
}