#ifndef _GAME_GUI_SDL_H
#define _GAME_GUI_SDL_H

#include "game-gui.hpp"

#include <SDL2/SDL.h>
#include <SDL2/SDL_image.h>
#include <SDL2/SDL_ttf.h>

#ifdef GAMEGUI_INCLUDE_VULKAN
   #include <SDL2/SDL_vulkan.h>
#endif

class GameGui_SDL : public GameGui {
   public:
      GameGui_SDL();

      string& getError();

      bool init();
      void shutdown();

      void* createWindow(const string& title, int width, int height, bool fullscreen);
      void destroyWindow();

      void processEvents();
      int pollEvent(UIEvent* event);
      bool keyPressed(unsigned int key);

      void refreshWindowSize();
      int getWindowWidth();
      int getWindowHeight();

#ifdef GAMEGUI_INCLUDE_VULKAN
      bool createVulkanSurface(VkInstance instance, VkSurfaceKHR* surface);
      vector<const char*> getRequiredExtensions();
#endif

   private:
      SDL_Window* window;
      int windowWidth, windowHeight;
      const Uint8* keyState;

      static string s_errorMessage;
};

#endif // _GAME_GUI_SDL_H