#version 450
#extension GL_ARB_separate_shader_objects : enable

layout(binding = 0) uniform sampler2D uiTexSampler;

layout(location = 0) in vec3 fragColor;
layout(location = 1) in vec2 fragTexCoord;
layout(location = 2) flat in uint isOverlay;

layout(location = 0) out vec4 outColor;

void main() {
   outColor = texture(uiTexSampler, fragTexCoord);

   if (isOverlay == 1) {
      outColor = texture(uiTexSampler, fragTexCoord);
   } else {
      outColor = vec4(fragColor * texture(uiTexSampler, fragTexCoord).rgb, 1.0);
   }
}