#ifndef _VULKAN_UTILS_H
#define _VULKAN_UTILS_H

#include <vector>

#include <vulkan/vulkan.h>

using namespace std;

class VulkanUtils {
   public:
      static bool checkValidationLayerSupport(const vector<const char*> &validationLayers);

      static VkResult createDebugUtilsMessengerEXT(VkInstance instance,
            const VkDebugUtilsMessengerCreateInfoEXT* pCreateInfo,
            const VkAllocationCallbacks* pAllocator,
            VkDebugUtilsMessengerEXT* pDebugMessenger);

      static void destroyDebugUtilsMessengerEXT(VkInstance instance,
            VkDebugUtilsMessengerEXT debugMessenger,
            const VkAllocationCallbacks* pAllocator);
};

#endif // _VULKAN_UTILS_H