package main;

import java.awt.Color;
import java.awt.Frame;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferStrategy;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;

import java.util.Iterator;
import java.util.LinkedList;

import gamegui.Align;
import gamegui.Animation;
import gamegui.Button;
import gamegui.Label;
import gamegui.Member;
import gamegui.MultiTextbox;
import gamegui.Textbox;
import gamegui.Window;

import utils.DynamicImage;
import utils.Utils;

public class LastDefenseMain implements KeyListener, MouseListener {
    private static final boolean RUNNING_FROM_JAR = false;
    GameState gameState;
    AuxState auxState;
    boolean started;
    boolean done;
    boolean showFps;
    int frameCount;
    int lastFrameCount;
    int refreshRate;
    long lastFpsUpdate;
    Graphics g;
    Frame frmMain;
    Window wndMain;
    Window wndInfo;
    Window wndCredits;
    Window wndDiagnostics;
    Window wndMessage;
    DynamicImage background;
    DynamicImage yellowCursor;
    DynamicImage greenCursor;
    DynamicImage redCursor;
    DynamicImage cursor;
    Textbox selectedText;
    Button selectedButton;
    Font font11;
    Font font12;
    Font font14;
    Font font24;
    Font fontTT;
    Font fontCustom11;
    Font fontCustom12;
    Font fontCustom14;
    Font fontCustom24;
    Font fontCustom30;
    Font fontCustom48;
    Font guiFont12;
    Font guiFont14;
    Color color1;
    Color color2;
    FontMetrics m;
    Color redHaze;
    Color blueHaze;
    LinkedList<Entity> lstObjects;
    LinkedList<Unit> lstShips;
    LinkedList<Unit> lstTurrets;
    long timeLastUpdated;
    int resources;
    Animation turret;
    Animation shield;
    Animation projectile;
    Animation assaultShip;
    Level[] levels;
    int curLevel;
    public static int resUsed;
    public static int shipsKilled;
    public static int turretsKilled;
    public static int shieldsKilled;
    boolean pause;
    long timePaused;
    long pauseDuration;
    boolean showCost;
    long timeShowingCost;
    long costDuration;
    int cost;
    
    public LastDefenseMain(final GraphicsDevice device) {
        this.started = false;
        this.pauseDuration = 3000L;
        this.costDuration = 1200L;
        try {
            final GraphicsConfiguration gc = device.getDefaultConfiguration();
            (this.frmMain = new Frame(gc)).setUndecorated(true);
            this.frmMain.setIgnoreRepaint(true);
            device.setFullScreenWindow(this.frmMain);
            if (device.isDisplayChangeSupported()) {
                Utils.chooseBestDisplayMode(device, 800, 600);
            }
            this.frmMain.addMouseListener(this);
            this.frmMain.addKeyListener(this);
            this.frmMain.createBufferStrategy(2);
            final BufferStrategy bufferStrategy = this.frmMain.getBufferStrategy();
            this.g = bufferStrategy.getDrawGraphics();
            this.refreshRate = device.getDisplayMode().getRefreshRate();
            Utils.init(gc, RUNNING_FROM_JAR);
            this.gameState = GameState.Main;
            this.auxState = AuxState.None;
            this.done = false;
            this.showFps = false;
            this.frameCount = 0;
            this.lastFrameCount = 0;
            this.lastFpsUpdate = System.nanoTime();
            this.selectedText = null;
            this.selectedButton = null;
            this.timeLastUpdated = 0L;
            this.lstObjects = new LinkedList<Entity>();
            this.lstShips = new LinkedList<Unit>();
            this.lstTurrets = new LinkedList<Unit>();
            final Toolkit tk = Toolkit.getDefaultToolkit();
            this.frmMain.setCursor(tk.createCustomCursor(tk.createImage(""), new Point(), null));
            this.loadGUI(bufferStrategy);
            this.loadObjects();
            this.started = true;
            while (!this.done) {
                this.g = bufferStrategy.getDrawGraphics();
                this.handleGameEvents();
                this.render(this.g);
                if (this.frmMain != null) {
                    this.detectMouseOver(this.g);
                    final Point e = MouseInfo.getPointerInfo().getLocation();
                    if (e != null) {
                        this.cursor.draw(this.g, e.x - 5, e.y - 2);
                    }
                }
                this.g.dispose();
                bufferStrategy.show();
                this.frameCount++;
                if (System.nanoTime() - 1000000000L >= this.lastFpsUpdate) {
                    this.lastFpsUpdate = System.nanoTime();
                    this.lastFrameCount = this.frameCount;
                    this.frameCount = 0;
                }
            }
        } catch (Throwable th) {
            th.printStackTrace();
            return;
        } finally {
            device.setFullScreenWindow(null);
        }
        device.setFullScreenWindow(null);
    }
    
    private void loadGUI(final BufferStrategy bufferStrategy) {
        (this.background = new DynamicImage("background.png")).draw(bufferStrategy.getDrawGraphics(), 0, 0);
        this.font11 = new Font("Arial", 0, 11);
        this.font12 = new Font("Arial", 0, 12);
        this.font14 = new Font("Arial", 0, 14);
        this.font24 = new Font("Arial", 0, 24);
        this.fontTT = new Font("Courier New", 0, 11);
        this.guiFont12 = new Font("Garamond", 1, 12);
        this.guiFont14 = new Font("Garamond", 1, 14);
        this.m = this.g.getFontMetrics(this.guiFont12);
        try {
            final Font fontCustom = Utils.loadFont("images/gui/Last_words.ttf");
            this.fontCustom11 = fontCustom.deriveFont(0, 11.0f);
            this.fontCustom12 = fontCustom.deriveFont(0, 12.0f);
            this.fontCustom14 = fontCustom.deriveFont(0, 14.0f);
            this.fontCustom24 = fontCustom.deriveFont(0, 24.0f);
            this.fontCustom30 = fontCustom.deriveFont(0, 30.0f);
            this.fontCustom48 = fontCustom.deriveFont(0, 48.0f);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.yellowCursor = new DynamicImage("gui/cursor.png");
        this.greenCursor = new DynamicImage("gui/cursorgreen.png");
        this.redCursor = new DynamicImage("gui/cursorred.png");
        this.cursor = this.yellowCursor;
        this.wndMain = new Window("main", 0, 0, 800, 600, true);
        FontMetrics metrics = this.g.getFontMetrics(this.fontCustom48);
        this.wndMain.add(new Button("title", 400 - metrics.stringWidth("Last Defense") / 2, 120, 0, 0, "Last Defense", this.fontCustom48, new Color(20, 200, 20), false));
        this.wndMain.background = this.background;
        this.color2 = Color.green;
        this.color1 = new Color(0, 160, 0);
        metrics = this.g.getFontMetrics(this.fontCustom30);
        this.wndMain.add(new Button("new game", 100, 270, metrics.stringWidth("Start Game"), metrics.getHeight(), "Start Game", this.fontCustom30, this.color1, false));
        this.wndMain.add(new Button("game info", 140, 320, metrics.stringWidth("Game Info"), metrics.getHeight(), "Game Info", this.fontCustom30, this.color1, false));
        metrics = this.g.getFontMetrics(this.fontCustom24);
        this.wndMain.add(new Button("credits", 15, 565, metrics.stringWidth("Credits"), metrics.getHeight(), "Credits", this.fontCustom24, this.color1, false));
        this.wndMain.add(new Button("quit", 730, 565, metrics.stringWidth("Quit"), metrics.getHeight(), "Quit", this.fontCustom24, this.color1, false));
        this.wndInfo = new Window("info", 0, 0, 800, 600, true);
        this.wndInfo.background = this.background;
        this.wndInfo.add(new Label("title", 250, 15, 300, 20, "Game Info", this.font24, new Color(0, 160, 0)));
        this.wndInfo.add(new MultiTextbox("info", 50, 120, 700, 430, "", false, this.font14, this.g.getFontMetrics(this.font14)));
        ((MultiTextbox)this.wndInfo.getMember("info")).setBorder(true);
        ((MultiTextbox)this.wndInfo.getMember("info")).setText("    You must defend against some sort of invasion. You have turrets and shields at your disposal. Turrets will automatically fire at enemy fighters and shields will generate a small forcefield that protects nearby turrets against enemy fire.\n    Use your left mouse button to place turrets and your right mouse button to place shields. Both of these cost resources, so make sure to use the resources you have wisely. You start with 100 resources and you can get more as you destroy enemy fighters. Each turret costs 30 resources and each shield costs 50 resources.\n    The enemy fighters descend in waves from the top of the screen. Once a wave is defeated, all surviving turrets and shields will have their hitpoints restored to full and the next wave will immediately come.\n    There are 20 waves total. Good luck!\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n(Click your mouse to return to the main menu)");
        this.wndInfo.add(new Label("", 150, 410, 100, 20, "Turret", this.font14, Align.Center));
        this.wndInfo.add(new Label("", 350, 410, 100, 20, "Shield", this.font14, Align.Center));
        this.wndInfo.add(new Label("", 550, 410, 100, 20, "Fighter", this.font14, Align.Center));
        (this.wndCredits = new Window("main", 0, 0, 800, 600, true)).add(new Label("title", 250, 15, 300, 20, "Credits", this.fontCustom24, this.color2));
        this.wndCredits.background = this.background;
        this.wndCredits.add(new Label("1", 250, 160, 300, 20, "Created By", this.guiFont14, this.color2));
        this.wndCredits.add(new Label("2", 250, 180, 300, 20, "Dmitry Portnoy", this.guiFont12, this.color2));
        this.wndCredits.add(new Label("4", 250, 220, 300, 20, "Free Art", this.guiFont14, this.color2));
        this.wndCredits.add(new Label("5", 250, 240, 300, 20, "martinstudio.kings-field.com", this.guiFont12, this.color2));
        (this.wndMessage = new Window("message", 290, 135, 220, 160)).add(new Label("label", 20, 15, 180, 12, "none", this.font12));
        this.wndMessage.add(new Button("button", 70, 115, 80, 30, "OK", this.font12, Align.Center));
        this.wndDiagnostics = new Window("diagnostics", 0, 0, 400, 140, true);
    }
    
    private void loadObjects() {
        (this.assaultShip = new Animation("", 0, 0, 64, 64, 200, true)).addFrame(new DynamicImage("ships/assault/assault1.png"));
        this.assaultShip.addFrame(new DynamicImage("ships/assault/assault2.png"));
        this.assaultShip.addFrame(new DynamicImage("ships/assault/assault3.png"));
        this.assaultShip.addFrame(new DynamicImage("ships/assault/assault4.png"));
        (this.turret = new Animation("", 0, 0, 42, 45, 200, true)).addFrame(new DynamicImage("turrets/turret2.png"));
        (this.shield = new Animation("", 0, 0, 70, 44, 200, true)).addFrame(new DynamicImage("turrets/shield.png"));
        (this.projectile = new Animation("", 0, 0, 4, 18, 200, true)).addFrame(new DynamicImage("laser.png"));
        this.levels = new Level[20];
        final int[] levelNum = { 3, 3, 4, 5, 6, 8, 10, 12, 14, 17, 20, 24, 28, 34, 40, 45, 50, 56, 62, 70 };
        for (int x = 0; x < levelNum.length; ++x) {
            this.levels[x] = new Level();
            for (int y = 0; y < levelNum[x]; ++y) {
                this.levels[x].addUnit(new Ship("", this.assaultShip, 5, 40, 200, this.projectile));
            }
        }
    }
    
    private void loadLevel(final Level l) {
        final Iterator<Ship> iter = l.lstUnits.iterator();
        while (iter.hasNext()) {
            this.addObject(new Ship(iter.next()));
        }
    }
    
    private synchronized void handleGameEvents() {
        switch (this.gameState) {
            case Game: {
                this.spawnObjects();
                this.updateObjects();
                break;
            }
        }
    }
    
    private synchronized void render(final Graphics g) {
        g.setColor(Color.black);
        g.fillRect(0, 0, 800, 600);
        switch (this.gameState) {
            case Main: {
                this.wndMain.draw(g);
                break;
            }
            case Info: {
                this.drawInfo(g);
                break;
            }
            case Credits: {
                this.drawCredits(g);
                break;
            }
            case Game: {
                this.drawGame(g);
                break;
            }
        }
        switch (this.auxState) {
            case MsgBox: {
                this.wndMessage.draw(g);
                g.drawString("Level reached: " + (this.curLevel + 1), 300, 200);
                g.drawString("Ships destroyed: " + LastDefenseMain.shipsKilled, 300, 215);
                g.drawString("Resources Used: " + LastDefenseMain.resUsed, 300, 230);
                g.drawString("Turrets lost: " + LastDefenseMain.turretsKilled, 430, 200);
                g.drawString("Shields lost: " + LastDefenseMain.shieldsKilled, 430, 215);
                break;
            }
        }
        if (this.showFps) {
            this.drawDiagnostics(g);
        }
    }
    
    public void showMessage(final String text) {
        this.auxState = AuxState.MsgBox;
        ((Label)this.wndMessage.getMember("label")).setText(text);
    }
    
    private void drawInfo(final Graphics g) {
        this.wndInfo.draw(g);
        this.turret.draw(g, 200, 400);
        this.shield.draw(g, 400, 400);
        this.assaultShip.draw(g, 600, 400);
    }
    
    private void drawCredits(final Graphics g) {
        this.wndCredits.draw(g);
    }
    
    private void drawGame(final Graphics g) {
        this.background.draw(g, 0, 0);
        for (final Unit cur : this.lstTurrets) {
            if (cur instanceof Shield) {
                final Shield shield = (Shield)cur;
                g.setColor(new Color(0, 0, 255, 100 * shield.hitpoints / shield.maxHitpoints));
                g.fillOval(shield.loc.getX() - shield.radius, shield.loc.getY() - shield.radius, shield.radius * 2, shield.radius * 2);
            }
        }
        final Iterator<Entity> iter = this.lstObjects.iterator();
        while (iter.hasNext()) {
            iter.next().draw(g);
        }
        g.setColor(Color.green);
        g.drawString("Resources: " + this.resources, 0, 15);
        g.drawString("Level: " + (this.curLevel + 1), 750, 15);
        if (this.showCost) {
            if (System.currentTimeMillis() - this.timeShowingCost >= this.costDuration) {
                this.showCost = false;
            } else {
                g.drawString(new StringBuilder().append(this.cost).toString(), MouseInfo.getPointerInfo().getLocation().x - 8, MouseInfo.getPointerInfo().getLocation().y - 25);
            }
        }
    }
    
    private void drawDiagnostics(final Graphics g) {
        this.wndDiagnostics.draw(g);
        g.setColor(Color.green);
        g.setFont(this.fontTT);
        g.drawString("Unthrottled FPS: " + this.lastFrameCount, 0, 15);
        g.drawString("Monitor Refresh Rate: " + this.refreshRate, 0, 30);
        g.drawString("Player Info", 0, 60);
    }
    
    private synchronized void detectMouseOver(final Graphics g) {
        final Point e = MouseInfo.getPointerInfo().getLocation();
        if (e == null) {
            return;
        }
        g.setFont(this.guiFont12);
        this.cursor = this.yellowCursor;
        switch (this.gameState) {
            case Main: {
                if (this.selectedButton != null) {
                    this.selectedButton.color = this.color1;
                }
                if (this.wndMain.getMember("new game").isClicked(e.x, e.y)) {
                    this.selectedButton = (Button)this.wndMain.getMember("new game");
                }
                else if (this.wndMain.getMember("game info").isClicked(e.x, e.y)) {
                    this.selectedButton = (Button)this.wndMain.getMember("game info");
                }
                else if (this.wndMain.getMember("credits").isClicked(e.x, e.y)) {
                    this.selectedButton = (Button)this.wndMain.getMember("credits");
                }
                else if (this.wndMain.getMember("quit").isClicked(e.x, e.y)) {
                    this.selectedButton = (Button)this.wndMain.getMember("quit");
                }
                else {
                    this.selectedButton = null;
                }
                if (this.selectedButton != null) {
                    this.selectedButton.color = this.color2;
                    break;
                }
                break;
            }
        }
    }
    
    private void spawnObjects() {
        if (this.timeLastUpdated == 0L) {
            this.timeLastUpdated = System.currentTimeMillis();
            return;
        }
        final long timeCurrent = System.currentTimeMillis();
        if (timeCurrent - this.timeLastUpdated >= 2000L) {
            this.timeLastUpdated = timeCurrent;
        }
    }
    
    private void updateObjects() {
        if (this.pause) {
            if (System.currentTimeMillis() - this.timePaused >= this.pauseDuration) {
                this.pause = false;
                this.loadLevel(this.levels[this.curLevel]);
            }
        }
        else if (this.lstShips.size() == 0) {
            this.pause = true;
            this.timePaused = System.currentTimeMillis();
            ++this.curLevel;
            if (this.curLevel == 20) {
                this.gameState = GameState.Main;
                this.showCost = false;
                this.showMessage("You have won!");
                return;
            }
            for (final Unit cur : this.lstTurrets) {
                cur.hitpoints = cur.maxHitpoints;
            }
        }
        else if (this.lstTurrets.size() == 0 && this.resources <= 30) {
            this.gameState = GameState.Main;
            this.showCost = false;
            this.showMessage("You have lost!");
            return;
        }
        final LinkedList<Entity> lstTemp = new LinkedList<Entity>();
        for (final Entity cur2 : this.lstObjects) {
            if (cur2 instanceof Ship) {
                cur2.update(lstTemp, this.lstTurrets);
            }
            else if (cur2 instanceof Shield) {
                cur2.update(this.lstObjects, null);
            }
            else {
                cur2.update(lstTemp, this.lstShips);
            }
        }
        Iterator<Entity> iter2 = this.lstObjects.iterator();
        while (iter2.hasNext()) {
            final Entity cur2 = iter2.next();
            if (cur2.remove) {
                iter2.remove();
                this.removeObject(cur2);
            }
        }
        iter2 = lstTemp.iterator();
        while (iter2.hasNext()) {
            this.addObject(iter2.next());
        }
    }
    
    private void addObject(final Entity obj) {
        if (obj instanceof Turret) {
            this.lstTurrets.add((Turret)obj);
        }
        else if (obj instanceof Shield) {
            this.lstTurrets.add((Shield)obj);
        }
        else if (obj instanceof Ship) {
            this.lstShips.add((Ship)obj);
        }
        this.lstObjects.add(obj);
    }
    
    private void removeObject(final Entity obj) {
        if (obj instanceof Turret) {
            this.lstTurrets.remove(obj);
            ++LastDefenseMain.turretsKilled;
        }
        if (obj instanceof Shield) {
            this.lstTurrets.remove(obj);
            ++LastDefenseMain.shieldsKilled;
        }
        else if (obj instanceof Ship) {
            this.lstShips.remove(obj);
            ++LastDefenseMain.shipsKilled;
            this.resources += 15;
        }
    }
    
    private synchronized void handleMouseInput(final MouseEvent e) {
        if (!this.started) {
            return;
        }
        this.selectText(null);
        switch (this.auxState) {
            case None: {
                switch (this.gameState) {
                    case Main: {
                        if (this.wndMain.getMember("new game").isClicked(e.getX(), e.getY())) {
                            this.lstObjects.clear();
                            this.lstTurrets.clear();
                            this.lstShips.clear();
                            this.addObject(new Turret("Turret", this.turret, 5, 40, 400, this.projectile));
                            this.lstTurrets.get(this.lstTurrets.size() - 1).setLocation(new Location(250.0, 450.0));
                            this.curLevel = 0;
                            this.resources = 100;
                            LastDefenseMain.resUsed = 0;
                            LastDefenseMain.shipsKilled = 0;
                            LastDefenseMain.turretsKilled = 0;
                            LastDefenseMain.shieldsKilled = 0;
                            this.pause = true;
                            this.showCost = false;
                            this.timePaused = System.currentTimeMillis();
                            this.gameState = GameState.Game;
                            break;
                        }
                        if (this.wndMain.getMember("game info").isClicked(e.getX(), e.getY())) {
                            this.gameState = GameState.Info;
                            break;
                        }
                        if (this.wndMain.getMember("credits").isClicked(e.getX(), e.getY())) {
                            this.gameState = GameState.Credits;
                            break;
                        }
                        if (this.wndMain.getMember("quit").isClicked(e.getX(), e.getY())) {
                            this.done = true;
                            break;
                        }
                        break;
                    }
                    case Info: {
                        this.gameState = GameState.Main;
                        break;
                    }
                    case Credits: {
                        this.gameState = GameState.Main;
                        break;
                    }
                    case Game: {
                        if (e.getButton() == 1) {
                            if (this.resources >= 30) {
                                this.resources -= 30;
                                LastDefenseMain.resUsed += 30;
                                this.addObject(new Turret("TurretX", this.turret, 5, 40, 400, this.projectile));
                                this.lstTurrets.get(this.lstTurrets.size() - 1).setLocation(new Location(e.getX(), e.getY()));
                                this.cost = -30;
                            }
                            else {
                                this.cost = 0;
                            }
                        }
                        else if (e.getButton() == 3) {
                            if (this.resources >= 50) {
                                this.resources -= 50;
                                LastDefenseMain.resUsed += 50;
                                this.addObject(new Shield("ShieldX", this.shield, 200, 100));
                                this.lstTurrets.get(this.lstTurrets.size() - 1).setLocation(new Location(e.getX(), e.getY()));
                                this.cost = -50;
                            }
                            else {
                                this.cost = 0;
                            }
                        }
                        if (this.cost != 0) {
                            this.showCost = true;
                            this.timeShowingCost = System.currentTimeMillis();
                            break;
                        }
                        break;
                    }
                }
                break;
            }
            case MsgBox: {
                if (this.wndMessage.getMember("button").isClicked(e.getX(), e.getY())) {
                    this.auxState = AuxState.None;
                    break;
                }
                break;
            }
        }
    }
    
    private synchronized void handleMouseRelease(final MouseEvent e) {
    }
    
    private synchronized void handleKeyboardInput(final KeyEvent e) {
        if (this.selectedText != null) {
            this.selectedText.handleEvent(e);
        }
        else if (e.getKeyCode() == 27) {
            if (this.gameState == GameState.Game || this.gameState == GameState.Info) {
                this.gameState = GameState.Main;
                this.showCost = false;
            }
            else {
                this.done = true;
            }
        }
        else if (e.getKeyCode() == 83) {
            this.showFps = !this.showFps;
        }
    }
    
    @Override
    public void mousePressed(final MouseEvent e) {
        this.handleMouseInput(e);
    }
    
    @Override
    public void mouseReleased(final MouseEvent e) {
        this.handleMouseRelease(e);
    }
    
    @Override
    public void mouseEntered(final MouseEvent e) {
    }
    
    @Override
    public void mouseExited(final MouseEvent e) {
    }
    
    @Override
    public void mouseClicked(final MouseEvent e) {
    }
    
    @Override
    public void keyTyped(final KeyEvent e) {
    }
    
    @Override
    public synchronized void keyPressed(final KeyEvent e) {
        this.handleKeyboardInput(e);
    }
    
    @Override
    public void keyReleased(final KeyEvent e) {
    }
    
    private void selectText(final Textbox text) {
        if (this.selectedText != null) {
            this.selectedText.setSelected(false);
        }
        if ((this.selectedText = text) != null) {
            text.setSelected(true);
        }
    }
    
    public static void main(final String[] args) {
        try {
            final PrintStream st = new PrintStream(new FileOutputStream("err.txt", true));
            System.setErr(st);
            System.setOut(st);
            System.out.println("-----[ Session started on " + Utils.dateString() + " ]-----");
            final GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
            final GraphicsDevice device = env.getDefaultScreenDevice();
            new LastDefenseMain(device);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }
    
    public enum AuxState {
        None,
        MsgBox
    }
    
    public enum GameState {
        Main, 
        Info, 
        Credits,
        Game
    }
}
