#version 410

#define MAX_NUM_OBJECTS 1024

uniform mat4 view, proj;

layout (std140) uniform models {
  mat4 model_mats[MAX_NUM_OBJECTS];
};

layout(location = 0) in vec3 vertex_position;
layout(location = 1) in vec3 vertex_color;
layout(location = 2) in vec3 vertex_normal;
layout(location = 3) in uint ubo_index;

out vec3 position_eye, normal_eye, color, light_position_eye, light2_position_eye;

// fixed point light position
vec3 light_position_world = vec3(0.0, 0.0, 2.0);
vec3 light2_position_world = vec3(0.0, -1.5, -0.2);

void main() {
  position_eye = vec3(view * model_mats[ubo_index] * vec4(vertex_position, 1.0));
  normal_eye = normalize(vec3(view * model_mats[ubo_index] * vec4(vertex_normal, 0.0)));
  color = vertex_color;
  light_position_eye = vec3(view * vec4(light_position_world, 1.0));
  light2_position_eye = vec3(view * vec4(light2_position_world, 1.0));

  gl_Position = proj * vec4(position_eye, 1.0);
}
