#ifndef _VULKAN_GAME_H
#define _VULKAN_GAME_H

#include "game-gui-sdl.hpp"

#ifdef NDEBUG
   const bool ENABLE_VALIDATION_LAYERS = false;
#else
   const bool ENABLE_VALIDATION_LAYERS = true;
#endif

class VulkanGame {
   public:
      VulkanGame();
      ~VulkanGame();

      void run(int width, int height, unsigned char guiFlags);

   private:
      GameGui* gui;

      SDL_version sdlVersion;
      SDL_Window* window;

      bool initWindow(int width, int height, unsigned char guiFlags);
      void initVulkan();
      void mainLoop();
      void cleanup();
};

#endif // _VULKAN_GAME_H