#ifndef _VULKAN_GAME_H
#define _VULKAN_GAME_H

#include "game-gui-sdl.hpp"

#ifdef NDEBUG
   const bool ENABLE_VALIDATION_LAYERS = false;
#else
   const bool ENABLE_VALIDATION_LAYERS = true;
#endif

class VulkanGame {
   public:
      VulkanGame();
      ~VulkanGame();

      void run(int width, int height, unsigned char guiFlags);

   private:
      GameGui* gui;

      SDL_version sdlVersion;
      SDL_Window* window;
      SDL_Renderer* renderer;

      VkInstance instance;
      VkDebugUtilsMessengerEXT debugMessenger;
      VkSurfaceKHR surface; // TODO: Change the variable name to vulkanSurface
      VkPhysicalDevice physicalDevice = VK_NULL_HANDLE;
      VkDevice device;

      VkQueue graphicsQueue;
      VkQueue presentQueue;

      bool initWindow(int width, int height, unsigned char guiFlags);
      void initVulkan();
      void mainLoop();
      void renderUI();
      void renderScene();
      void cleanup();

      void createVulkanInstance(const vector<const char*> &validationLayers);
      void setupDebugMessenger();
      void populateDebugMessengerCreateInfo(VkDebugUtilsMessengerCreateInfoEXT& createInfo);
      void createVulkanSurface();
      void pickPhysicalDevice(const vector<const char*>& deviceExtensions);
      bool isDeviceSuitable(VkPhysicalDevice device, const vector<const char*>& deviceExtensions);
      void createLogicalDevice(
         const vector<const char*> validationLayers,
         const vector<const char*>& deviceExtensions);
      void cleanupSwapChain();

      static VKAPI_ATTR VkBool32 VKAPI_CALL debugCallback(
            VkDebugUtilsMessageSeverityFlagBitsEXT messageSeverity,
            VkDebugUtilsMessageTypeFlagsEXT messageType,
            const VkDebugUtilsMessengerCallbackDataEXT* pCallbackData,
            void* pUserData);
};

#endif // _VULKAN_GAME_H