package com.medievaltech.gui;

import android.graphics.Canvas;
import android.graphics.Paint;

public class Button extends GUIObject {
	private String text;
	private Paint textPaint;
	private float vOffset;
	
	public Button(String newText, int newX, int newY, int newWidth, int newHeight, Paint linePaint, Paint textPaint) {
		super(newX, newY, newWidth, newHeight, linePaint);
		
		this.textPaint = textPaint;
		text = newText;	
		vOffset = -(textPaint.getFontMetrics().ascent+textPaint.getFontMetrics().descent)/2;
	}
	
	public void draw(Canvas c) {
		c.drawRect(x, y, x+width, y+height, p);
		c.drawText(text, x+width/2, y+height/2+vOffset, textPaint);
	} 
}