package com.medievaltech.game;

import java.util.List;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;

public abstract class Unit 
{
	public enum Type
	{
		LAND,SEA
	}

	private Paint p;
	
	public Type type;
	public Player owner;
	
	public int maxHealth;
	public int currentHealth;
	
	public int maxFuel;
	public int currentFuel;
	
	public int sightRange;
	public int move;
	
	public int minAttackRange;
	public int maxAttackRange;
	public Point location;
	
	public Unit(Paint p) {
		this.p = p;
	}
	
	public abstract boolean move(Point point);
	public abstract boolean attack(Point point);
	
	public abstract List<Point> getRange();
	public abstract List<Point> getAttackRange();
	
	public  void die() {
		
	}
	
	public void draw(Canvas c, int x, int y) {
		c.drawCircle(x, y, 20, p);
	}
}
