package com.medievaltech.advancewars;

import java.io.*;
import java.util.*;

import com.medievaltech.advancewars.Enum.*;
import com.medievaltech.unit.*;
import com.medievaltech.gui.*;

import android.content.Context;
import android.graphics.*;
import android.os.*;
import android.view.*;
import android.view.ContextMenu.ContextMenuInfo;
import android.util.AttributeSet;
import android.util.Log;

class GameView extends SurfaceView implements SurfaceHolder.Callback {
	
    class DrawingThread extends Thread {
    	
        private Unit selectedUnit;

        private Paint mLinePaint, mTextPaint, mButtonPaint, mTilePaint1,
        			mTilePaint2, mSelectionPaint, mUnitPaint1, mUnitPaint2;

        /** Handle to the surface manager object we interact with */
        private SurfaceHolder mSurfaceHolder;
        
        public DrawingThread(SurfaceHolder surfaceHolder, Context context, Handler handler) {
            mSurfaceHolder = surfaceHolder;
            
            mLinePaint = new Paint();
            initPaint(mLinePaint, 0, 255, 0);

            mTextPaint = new Paint();
            mTextPaint.setTextSize(12);
            mTextPaint.setTextAlign(Paint.Align.CENTER);
            initPaint(mTextPaint, 255, 255, 255);
            
            mButtonPaint = new Paint();
            mButtonPaint.setTextSize(20);
            mButtonPaint.setTextAlign(Paint.Align.CENTER);
            initPaint(mButtonPaint, 0, 0, 0);
            
            mTilePaint1 = new Paint();
            initPaint(mTilePaint1, 0, 255, 0);
            
            mTilePaint2 = new Paint();
            initPaint(mTilePaint2, 0, 0, 255);
            
            mUnitPaint1 = new Paint();
            initPaint(mUnitPaint1, 255, 0, 0);
            
            mUnitPaint2 = new Paint();
            initPaint(mUnitPaint2, 160, 160, 255);
            
            mSelectionPaint = new Paint();
            initPaint(mSelectionPaint, 255, 127, 0);
            
            Player.neutralColor = new Paint();
            initPaint(Player.neutralColor, 127, 127, 127);
            
            Static.wndMainMenu = new com.medievaltech.gui.Window(0, 0, 320, 450);
            Static.wndMainMenu.addGUIObject("txtTitle", new Text("Main Menu", 100, 30, 120, 20, mTextPaint));
            Static.wndMainMenu.addGUIObject("btnNewGame", new Button("New Game", 100, 90, 120, 20, mLinePaint, mButtonPaint));
            Static.wndMainMenu.addGUIObject("btnLoadGame", new Button("Load Game", 100, 125, 120, 20, mLinePaint, mButtonPaint));
            Static.wndMainMenu.addGUIObject("btnMapEditor", new Button("Map Editor", 100, 160, 120, 20, mLinePaint, mButtonPaint));
            Static.wndMainMenu.addGUIObject("btnQuit", new Button("Quit", 100, 195, 120, 20, mLinePaint, mButtonPaint));
            
            Static.grassTile = new Tile(mTilePaint1, TerrainType.LAND);
            Static.oceanTile = new Tile(mTilePaint2, TerrainType.SEA);
            
            Static.map = new Map(Static.grassTile, 6, 8, new Point(10, 25));
            
            boolean land = true;
            
            for(int x=0; x<Static.map.getWidth(); x++) {
    			for(int y=0; y<Static.map.getHeight(); y++) {
    				if(land)
    					Static.map.setTile(x, y, new Tile(Static.grassTile, new Point(x, y)));
    				else
    					Static.map.setTile(x, y, new Tile(Static.oceanTile, new Point(x, y)));
    				land = !land;
    			}
    			land = !land;
            }
            
            Static.human = new Player("Human", mUnitPaint1);
            Static.enemy = new Player("Comp", mUnitPaint2);
            
            Static.map.getTile(0, 0).addUnit(new Soldier(Static.enemy));
            Static.map.getTile(2, 3).addUnit(new Soldier(Static.human));
            Static.map.getTile(5, 6).addUnit(new Soldier(Static.human));
            
            Static.map.getTile(4, 4).addBuilding(new City());
            
            Static.turn = Turn.YOUR_TURN;
            
            Static.gameState = GameState.MAIN_MENU;
        }
        
        public void initPaint(Paint p, int r, int g, int b) {
            p.setAntiAlias(true);
            p.setARGB(255, r, g, b);
        }
        
        /**
         * Starts the game, setting parameters for the current difficulty.
         */
        // I don't think this gets called now. maybe we should call it in the thread constructor
        public void doStart() {
            synchronized (mSurfaceHolder) {
                Log.i("AdvanceWars", "Player's turn starting now");
                Static.gameState = GameState.MAIN_MENU;
            }
        }

        @Override
        public void run() {
            while (Static.run) {
                Canvas c = null;
                try {
                    c = mSurfaceHolder.lockCanvas(null);
                    synchronized(mSurfaceHolder) {
                    	doLogic();
                        doDraw(c);
                    }
                } finally {
                    // do this in a finally so that if an exception is thrown
                    // during the above, we don't leave the Surface in an
                    // inconsistent state
                    if (c != null) {
                        mSurfaceHolder.unlockCanvasAndPost(c);
                    }
                }
            }
        }
        
        public void setGameState(GameState state) {
            synchronized (mSurfaceHolder) {
            	Static.gameState = state;
            }
        }
        
        /* Callback invoked when the surface dimensions change. */
        public void setSurfaceSize(int width, int height) {
            synchronized (mSurfaceHolder) {
                Log.i("AdvanceWars", "width: "+width+", height: "+height);
            }
        }
        
        private void doLogic() {
        	if(Static.turn == Turn.YOUR_TURN)
        		return;
        	
        	switch(Static.gameState) {
        	case BATTLE_MAP:
        		Iterator<Unit> iter = Static.enemy.getControlledUnits().iterator();
        		Unit cur;
        		int x, y;
        		
        		Log.i("AdvanceWars", "starting to move enemy units");
        		while(iter.hasNext()) {
        			cur = iter.next();
        			x = cur.location.x;
            		y = cur.location.y;
            		
            		Log.i("AdvanceWars", "moving enemy unit");
            		
            		//any unit that's in the way is removed (needs to be changed eventuallyy)
            		Static.map.getTile(x, y).removeUnit();
            		Static.map.getTile(x, y+1).addUnit(cur);
        		}
        		Log.i("AdvanceWars", "finished moving enemy units");
        		
				
        		Static.turn = Turn.YOUR_TURN;
        		break;
        	}
        }

        /**
         * Draws the ship, fuel/speed bars, and background to the provided
         * Canvas.
         */
        private void doDraw(Canvas canvas) {
        	canvas.drawColor(Color.BLACK);
        	
        	switch(Static.gameState) {
        	case MAIN_MENU:
            	Static.wndMainMenu.draw(canvas);
        		break;
        	case BATTLE_MAP:
        		mTextPaint.setTextSize(12);
            	
        		Static.map.draw(canvas);
            	
            	if(selectedUnit != null) {
	            	for(Point p : selectedUnit.getMovementRange()) {
	            		canvas.drawRect(p.x*50+10, p.y*50+25, p.x*50+50+10, p.y*50+50+25, mSelectionPaint);
	            	}
            	}
            	
            	Static.map.drawBuildings(canvas);
            	Static.map.drawUnits(canvas);
            	
        		break;
        	}
        }
    }
    
    public GameView(Context context, AttributeSet attrs) {
        super(context, attrs);

        // register our interest in hearing about changes to our surface
        SurfaceHolder holder = getHolder();
        holder.addCallback(this);

        // create thread only; it's started in surfaceCreated()
        Static.thread = new DrawingThread(holder, context, new Handler() {});

        setFocusable(true); // make sure we get key events
    }

    @Override public boolean onTouchEvent(MotionEvent event) {
    	Log.i("AdvanceWars", "Detected touch event");
    	
    	if(event.getAction() == MotionEvent.ACTION_UP) {
    		Log.i("AdvanceWars", "Detected UP touch action");
    		switch(Static.gameState) {
    		case MAIN_MENU:
    			if(Static.wndMainMenu.getGUIObject("btnNewGame").isClicked(event.getX(), event.getY())) {
    				Log.i("AdvanceWars", "Switching to battle map");
    				Static.gameState = GameState.BATTLE_MAP;
    			}else if(Static.wndMainMenu.getGUIObject("btnLoadGame").isClicked(event.getX(), event.getY())) {
    				BufferedReader b;
            		try {
            			b = new BufferedReader(new FileReader(android.os.Environment.getExternalStorageDirectory()+"/save.txt"));
            			
            			int width = Integer.parseInt(b.readLine());
            			int height = Integer.parseInt(b.readLine());
            			
            			String offset = b.readLine();
            			Log.i("GameSave", offset);
            			int offsetX = Integer.parseInt(offset.substring(0, offset.indexOf("x")));
            			int offsetY = Integer.parseInt(offset.substring(offset.indexOf("x")+1));
            			
            			Static.map = new Map(Static.grassTile, width, height, new Point(offsetX, offsetY));
            			
            			Log.i("GameSave", "Created the map");
            			
            			for(int x=0; x<width; x++) {
            				String line = b.readLine();
            				Log.i("GameSave", line);
            				String[] arr = line.split(",");
            				for(int y=0; y<arr.length; y++) {
            					TerrainType type = TerrainType.values()[Integer.parseInt(arr[y])];
            					if(type.equals(TerrainType.LAND))
            						Static.map.setTile(x, y, new Tile(Static.grassTile, new Point(10, 25)));
                				else
                					Static.map.setTile(x, y, new Tile(Static.oceanTile, new Point(10, 25)));
            				}
            			}
            			
            			while(b.ready()) {
            				String unit = b.readLine();
            				Log.i("GameSave", unit);
            				int x = Integer.parseInt(unit.substring(0, unit.indexOf(",")));
                			int y = Integer.parseInt(unit.substring(unit.indexOf(",")+1));
            				
                			Player humanPlayer = new Player("Human", Static.thread.mUnitPaint1);
                			
                			Static.map.getTile(x, y).addUnit(new Soldier(humanPlayer));
            			}
            			
            			b.close();
            		}catch(IOException ioe) {
            			ioe.printStackTrace();
            		}
            		Static.gameState = GameState.BATTLE_MAP;
    			}else if(Static.wndMainMenu.getGUIObject("btnQuit").isClicked(event.getX(), event.getY())) {
    				Static.game.finish();
    			}
    			break;
    		case BATTLE_MAP:
    			Log.i("AdvanceWars", "Touch event detected on battle map");
    			
    			if(event.getX() >= Static.map.offset.x && event.getY() >= Static.map.offset.y) {
    				int x = ((int)event.getX() - Static.map.offset.x) / 50;
    				int y = ((int)event.getY() - Static.map.offset.y) / 50;
    				
    				Log.i("AdvanceWars", "About to show context menu");
    				showContextMenu();
    				
    				/*
    				
    				Unit target = Static.map.getTile(x, y).currentUnit;
    				
    				if(Static.thread.selectedUnit != null && Static.thread.selectedUnit.getMovementRange().contains(new Point(x, y))) {
    					//Display a menu allowing the player to move to the target or attack the target or
    					//get more info on the target
    					
    					if(target == null || target == Static.thread.selectedUnit) {
    							Static.map.getTile(Static.thread.selectedUnit.location.x, Static.thread.selectedUnit.location.y).removeUnit();
    							Static.map.getTile(x, y).addUnit(Static.thread.selectedUnit);
    					}else {
    						// Display a context menu that gives the option of attacking the target
    					}
    					Static.thread.selectedUnit = null;
    				}else
    					Static.thread.selectedUnit = target;
    				*/
    			}
    			
    			Log.i("AdvanceWars", "Touch event handling finished");
    			
    			break;
    		}
    	}else if(event.getAction() == MotionEvent.ACTION_DOWN) {
	    	
    	}
        
        return true;
    }

    /* Callback invoked when the surface dimensions change. */
    public void surfaceChanged(SurfaceHolder holder, int format, int width,
            int height) {
    	Static.thread.setSurfaceSize(width, height);
    }

    /*
     * Callback invoked when the Surface has been created and is ready to be
     * used.
     */
    public void surfaceCreated(SurfaceHolder holder) {
    	Static.run = true;
    	Static.thread.start();
    }

    /*
     * Callback invoked when the Surface has been destroyed and must no longer
     * be touched. WARNING: after this method returns, the Surface/Canvas must
     * never be touched again!
     */
    public void surfaceDestroyed(SurfaceHolder holder) {
        // we have to tell thread to shut down & wait for it to finish, or else
        // it might touch the Surface after we return and explode
        boolean retry = true;
        Static.run = false;
        while (retry) {
            try {
            	Static.thread.join();
                retry = false;
            } catch (InterruptedException e) {
            }
        }
    }
}
