# TODO: Figure out why calling this from a makefile gives an error about shopt not being found

# This section is left here in case there's no easy way to get glslangValidator in the path on a Mac

OS=$(uname)

if [ $OS = "Darwin" ]; then
   VULKAN_SDK_PATH=/Users/dportnoy15/Development/vulkan-sdk-macos-1.1.108.0/macOS
fi

cd shaders

shopt -s nullglob
shopt -s extglob

FILES=./!(*.spv)

for f in $FILES
do
   shaderName=$(echo $f | sed 's/\.\/\(.*\)\..*/\1/')
   shaderType=$(echo $f | sed 's/\.\/.*\.\(.*\)/\1/')
   fOut="$shaderName-$shaderType.spv"

   glslangValidator -V $f -o $fOut
done

cd ..
