#include "vulkan-game.hpp"

#include <iostream>

#include "consts.hpp"

#define GAMEGUI_INCLUDE_VULKAN
#include "game-gui-sdl.hpp"

using namespace std;

VulkanGame::VulkanGame() {
   gui = nullptr;
   window = nullptr;
}

VulkanGame::~VulkanGame() {
}

void VulkanGame::run(int width, int height, unsigned char guiFlags) {
   if (initWindow(width, height, guiFlags) == RTWO_ERROR) {
      return;
   }

   initVulkan();
   mainLoop();
   cleanup();
}

bool VulkanGame::initWindow(int width, int height, unsigned char guiFlags) {
   gui = new GameGui_SDL();

   if (gui->init() == RTWO_ERROR) {
      cout << "UI library could not be initialized!" << endl;
      cout << gui->getError() << endl;
      return RTWO_ERROR;
   }

   window = (SDL_Window*) gui->createWindow("Vulkan Game", width, height, guiFlags & GUI_FLAGS_WINDOW_FULLSCREEN);
   if (window == nullptr) {
      cout << "Window could not be created!" << endl;
      return RTWO_ERROR;
   }

   int actualWidth, actualHeight;
   gui->getWindowSize(&actualWidth, &actualHeight);

   cout << "Target window size: (" << width << ", " << height << ")" << endl;
   cout << "Actual window size: (" << actualWidth << ", " << actualHeight << ")" << endl;

   return RTWO_SUCCESS;
}

void VulkanGame::initVulkan() {
}

void VulkanGame::mainLoop() {
   SDL_Event e;
   bool quit = false;

   while (!quit) {
      while (SDL_PollEvent(&e)) {
         if (e.type == SDL_QUIT) {
            quit = true;
         }
         if (e.type == SDL_KEYDOWN) {
            quit = true;
         }
         if (e.type == SDL_MOUSEBUTTONDOWN) {
            quit = true;
         }
      }
   }
}

void VulkanGame::cleanup() {
   gui->destroyWindow();
   gui->shutdown();
   delete gui;
}