#include "opengl-game.hpp"

#include <iostream>

#include "consts.hpp"

#include "game-gui-glfw.hpp"

using namespace std;

OpenGLGame::OpenGLGame() {
   gui = nullptr;
   window = nullptr;
}

OpenGLGame::~OpenGLGame() {
}

void OpenGLGame::run(int width, int height, unsigned char guiFlags) {
   if (initWindow(width, height, guiFlags) == RTWO_ERROR) {
      return;
   }

   initOpenGL();
   mainLoop();
   cleanup();
}

bool OpenGLGame::initWindow(int width, int height, unsigned char guiFlags) {
   gui = new GameGui_GLFW();

   if (gui->init() == RTWO_ERROR) {
      cout << "UI library could not be initialized!" << endl;
      cout << gui->getError() << endl;
      return RTWO_ERROR;
   }
   cout << "GUI init succeeded" << endl;

   window = (GLFWwindow*) gui->createWindow("OpenGL Game", width, height, guiFlags & GUI_FLAGS_WINDOW_FULLSCREEN);
   if (window == nullptr) {
      cout << "Window could not be created!" << endl;
      return RTWO_ERROR;
   }

   int actualWidth=0, actualHeight=0;
   gui->getWindowSize(&actualWidth, &actualHeight);

   cout << "Target window size: (" << width << ", " << height << ")" << endl;
   cout << "Actual window size: (" << actualWidth << ", " << actualHeight << ")" << endl;

   return RTWO_SUCCESS;
}

void OpenGLGame::initOpenGL() {
}

void OpenGLGame::mainLoop() {
   while (!glfwWindowShouldClose(window)) {
      glfwPollEvents();

      if (GameGui_GLFW::s_keyState[GLFW_KEY_ESCAPE] == GLFW_PRESS) {
         glfwSetWindowShouldClose(window, 1);
      }

      glfwSwapBuffers(window);
   }
}

void OpenGLGame::cleanup() {
   gui->destroyWindow();
   gui->shutdown();
   delete gui;
}