#include <iostream>

// GLEW
#define GLEW_STATIC
#include <GL/glew.h>

// GLFW
#include <GLFW/glfw3.h>

#if defined(__linux__)
   #define LINUX
#elif defined(_WIN32)
	#define WINDOWS
#elif defined(__APPLE__)
   #define MAC
#endif

#define FULLSCREEN false

using namespace std;

void key_callback(GLFWwindow* window, int key, int scancode, int action, int mode);

const GLuint WIDTH = 800, HEIGHT = 600;

int main(int argc, char* argv[]) {
   cout << "Starting OpenGL game..." << endl;

   cout << "Starting GLFW context, OpenGL 3.3" << endl;
   // Init GLFW
   glfwInit();

   // Set all the required options for GLFW
   glfwWindowHint(GLFW_CONTEXT_VERSION_MAJOR, 3);
   glfwWindowHint(GLFW_CONTEXT_VERSION_MINOR, 3);
   glfwWindowHint(GLFW_OPENGL_PROFILE, GLFW_OPENGL_CORE_PROFILE);
   glfwWindowHint(GLFW_RESIZABLE, GL_FALSE);

   #ifdef MAC // required in OSX
      glfwWindowHint(GLFW_OPENGL_FORWARD_COMPAT, GL_TRUE);
   #endif

   // Create a GLFWwindow object that we can use for GLFW's functions
   GLFWmonitor* monitor = FULLSCREEN ? glfwGetPrimaryMonitor() : nullptr;
   
   GLFWwindow* window = glfwCreateWindow(WIDTH, HEIGHT, "LearnOpenGL", monitor, nullptr);
   glfwMakeContextCurrent(window);
   if (window == NULL) {
      cout << "Failed to create GLFW window" << endl;
      glfwTerminate();
      return EXIT_FAILURE;
   }

   // Set the required callback functions
   glfwSetKeyCallback(window, key_callback);

   // Set this to true so GLEW knows to use a modern approach to retrieving function pointers and extensions
   glewExperimental = GL_TRUE;
   // Initialize GLEW to setup the OpenGL Function pointers
   if (glewInit() != GLEW_OK) {
      cout << "Failed to initialize GLEW" << endl;
      return EXIT_FAILURE;
   }    

   // Define the viewport dimensions
   int width, height;
   glfwGetFramebufferSize(window, &width, &height);
   glViewport(0, 0, width, height);

   // Game loop
   while (!glfwWindowShouldClose(window)) {
      // Check if any events have been activiated (key pressed, mouse moved etc.) and call corresponding response functions
      glfwPollEvents();

      // Render
      // Clear the colorbuffer
      glClearColor(0.2f, 0.3f, 0.3f, 1.0f);
      glClear(GL_COLOR_BUFFER_BIT);

      // Swap the screen buffers
      glfwSwapBuffers(window);
   }

   glfwTerminate();
   return EXIT_SUCCESS;
}

// Is called whenever a key is pressed/released via GLFW
void key_callback(GLFWwindow* window, int key, int scancode, int action, int mode) {
   std::cout << key << std::endl;
   if (key == GLFW_KEY_ESCAPE && action == GLFW_PRESS)
      glfwSetWindowShouldClose(window, GL_TRUE);
}
