package main;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.*;
import java.util.HashMap;

import javax.imageio.ImageIO;

public class Map {

  private Location[][] grid;

  public Map(int x, int y) {
    this.grid = new Location[x][y];
  }

  public Map(String mapFile, String structFile, HashMap<LandType, Land> landMap, HashMap<StructureType, Structure> structMap, boolean readMapFromImage) {
    if (readMapFromImage) {
      try {
        BufferedImage img = ImageIO.read(getClass().getResource("/images/" + mapFile));
        int length = img.getHeight();
        int height = img.getWidth();
        this.grid = new Location[height][length];
        int x;
        for (x = 0; x < height; x++) {
          for (int y = 0; y < length; y++) {
            String loc;
            Color clr = new Color(img.getRGB(x, y));
            if (clr.getRed() == 243 && clr.getGreen() == 119 && clr.getBlue() == 0) {
              loc = "Lava";
            } else if (clr.getRed() == 128 && clr.getGreen() == 0 && clr.getBlue() == 0) {
              loc = "Metal";
            } else if (clr.getRed() == 255 && clr.getGreen() == 0 && clr.getBlue() == 0) {
              loc = "Charred";
            } else if (clr.getRed() == 95 && clr.getGreen() == 155 && clr.getBlue() == 0) {
              loc = "Swamp";
            } else if (clr.getRed() == 0 && clr.getGreen() == 67 && clr.getBlue() == 0) {
              loc = "Vines";
            } else if (clr.getRed() == 255 && clr.getGreen() == 0 && clr.getBlue() == 255) {
              loc = "Crystal";
            } else if (clr.getRed() == 128 && clr.getGreen() == 0 && clr.getBlue() == 128) {
              loc = "CrystalFormation";
            } else if (clr.getRed() == 0 && clr.getGreen() == 0 && clr.getBlue() == 255) {
              loc = "Water";
            } else if (clr.getRed() == 0 && clr.getGreen() == 128 && clr.getBlue() == 0) {
              loc = "Forest";
            } else if (clr.getRed() == 139 && clr.getGreen() == 63 && clr.getBlue() == 43) {
              loc = "Tree";
            } else if (clr.getRed() == 179 && clr.getGreen() == 247 && clr.getBlue() == 207) {
              loc = "Plains";
            } else if (clr.getRed() == 255 && clr.getGreen() == 255 && clr.getBlue() == 0) {
              loc = "Desert";
            } else if (clr.getRed() == 83 && clr.getGreen() == 83 && clr.getBlue() == 83) {
              loc = "Mountains";
            } else if (clr.getRed() == 8 && clr.getGreen() == 0 && clr.getBlue() == 0) {
              loc = "Cave";
            } else if (clr.getRed() == 0 && clr.getGreen() == 0 && clr.getBlue() == 128) {
              loc = "Ocean";
            } else if (clr.getRed() == 0 && clr.getGreen() == 255 && clr.getBlue() == 255) {
              loc = "Snow";
            } else if (clr.getRed() == 160 && clr.getGreen() == 160 && clr.getBlue() == 164) {
              loc = "Steam";
            } else {
              loc = "Mountains";
            }
            this.grid[x][y] = new Location(landMap.get(LandType.valueOf(loc)), structMap.get(StructureType.None));
          }
        }
        BufferedReader in = new BufferedReader(new FileReader(structFile));
        String str;
        while ((str = in.readLine()) != null) {
          String loc = in.readLine();
          x = Integer.valueOf(loc.substring(0, loc.indexOf(","))).intValue();
          int y = Integer.valueOf(loc.substring(loc.indexOf(",") + 1)).intValue();
          Point loc1 = new Point((x - 1) * 100 + 50, (y - 1) * 100 + 50);
          if (str.equals("ArtifactPoint") || str.equals("BossPoint")) {
            String strTarg = in.readLine();
            int x2 = Integer.valueOf(strTarg.substring(0, strTarg.indexOf(","))).intValue();
            int y2 = Integer.valueOf(strTarg.substring(strTarg.indexOf(",") + 1)).intValue();
            Point loc2 = new Point((x2 - 1) * 100 + 50, (y2 - 1) * 100 + 50);
            ArtifactPoint struct = new ArtifactPoint((ArtifactPoint)structMap.get(StructureType.valueOf(str)), loc1);
            struct.setTarget(loc2);
            this.grid[x - 1][y - 1].setStruct(struct);
            ArtifactPoint struct2 = new ArtifactPoint((ArtifactPoint)structMap.get(StructureType.valueOf(str)), loc2);
            struct2.setTarget(loc1);
            this.grid[x2 - 1][y2 - 1].setStruct(struct2);
            continue;
          }
          if (str.equals("RespawnPoint")) {
            this.grid[x - 1][y - 1].setStruct(new RespawnPoint((RespawnPoint)structMap.get(StructureType.valueOf(str)), loc1));
            LostHavenRPG.respawnPoints.add((RespawnPoint)this.grid[x - 1][y - 1].getStruct());
            continue;
          }
          this.grid[x - 1][y - 1].setStruct(new Structure(structMap.get(StructureType.valueOf(str)), loc1));
        }
        in.close();
      } catch (IOException ioe) {
        ioe.printStackTrace();
      }
    } else {
      try {
        BufferedReader in = new BufferedReader(new FileReader("/" + mapFile));
        String str = in.readLine();
        int length = Integer.parseInt(str.substring(0, str.indexOf("x")));
        int height = Integer.parseInt(str.substring(str.indexOf("x") + 1));
        this.grid = new Location[length][height];
        int x;
        for (x = 0; x < height; x++) {
          str = in.readLine();
          for (int y = 0; y < length; y++) {
            String loc;
            if (str.indexOf(",") == -1) {
              loc = str;
            } else {
              loc = str.substring(0, str.indexOf(","));
              str = str.substring(str.indexOf(",") + 1);
            }
            if (loc.equals("o")) {
              loc = "OceanOld";
            } else if (loc.equals("1")) {
              loc = "GrassOld";
            }
            this.grid[y][x] = new Location(landMap.get(LandType.valueOf(loc)), structMap.get(StructureType.None));
          }
        }
        in.close();
        in = new BufferedReader(new FileReader(structFile));
        while ((str = in.readLine()) != null) {
          String loc = in.readLine();
          x = Integer.valueOf(loc.substring(0, loc.indexOf(","))).intValue();
          int y = Integer.valueOf(loc.substring(loc.indexOf(",") + 1)).intValue();
          this.grid[x - 1][y - 1].setStruct(structMap.get(StructureType.valueOf(str)));
        }
        in.close();
      } catch (IOException ioe) {
        ioe.printStackTrace();
      }
    }
  }

  public void clearCreatures() {
    for (int x = 0; x < getLength(); x++) {
      for (int y = 0; y < getHeight(); y++) {
        getLoc(x, y).getCreatures().clear();
      }
    }
  }

  public Location getLoc(int x, int y) {
    return this.grid[x][y];
  }

  public void setLoc(Location loc, int x, int y) {
    this.grid[x][y] = loc;
  }

  public int getLength() {
    return this.grid.length;
  }

  public int getHeight() {
    if (this.grid.length > 0) {
      return (this.grid[0]).length;
    }
    return 0;
  }
}
