package gamegui;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class RadioButton extends Member {

  private String text;
  private Font font;
  private boolean textAfter;
  private boolean selected;

  public RadioButton(String newName, int newX, int newY, int newWidth, int newHeight, String newText, Font newFont, boolean isTextAfter) {
    super(newName, newX, newY, newWidth, newHeight);
    this.text = newText;
    this.font = newFont;
    this.textAfter = isTextAfter;
  }

  public void draw(Graphics g) {
    FontMetrics metrics = g.getFontMetrics(this.font);
    g.setColor(Color.red);
    g.drawOval(getX(), getY(), getWidth(), getHeight());
    if (this.selected) {
      g.setColor(Color.green);
      g.fillOval(getX() + 5, getY() + 5, getWidth() - 10, getHeight() - 10);
    }
    g.setColor(Color.green);
    g.setFont(this.font);
    if (this.textAfter) {
      g.drawString(this.text, getX() + getWidth() + 7, getY() + (getHeight() + metrics.getHeight()) / 2 - 2);
    } else {
      g.drawString(this.text, getX() - metrics.stringWidth(this.text) - 7, getY() + (getHeight() + metrics.getHeight()) / 2 - 2);
    }
  }

  public void clear() {
    this.selected = false;
  }

  public String getLabel() {
    return this.text;
  }

  public boolean isClicked(int xCoord, int yCoord) {
    double distance = Math.sqrt(Math.pow((getX() + getWidth() / 2 - xCoord), 2.0D) + Math.pow((getY() + getHeight() / 2 - yCoord), 2.0D));
    return !(distance > (getWidth() / 2));
  }

  public boolean isSelected() {
    return this.selected;
  }

  public void setSelected(boolean isSelected) {
    this.selected = isSelected;
  }
}
