package gamegui;

import java.awt.*;
import java.awt.event.*;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public class MultiTextbox extends Textbox {

  ArrayList<String> lstStrings;
  FontMetrics metrics;
  boolean active;

  public MultiTextbox(String newName, int newX, int newY, int newWidth, int newHeight, String newLabel, boolean isActive, Font newFont, FontMetrics newMetrics) {
    super(newName, newX, newY, newWidth, newHeight, newLabel, newFont, false);
    this.lstStrings = new ArrayList<String>();
    this.metrics = newMetrics;
    this.active = isActive;
    splitString();
  }

  public void append(String str) {
    if (getText().equals("")) {
      setText(str);
    } else {
      setText(String.valueOf(getText()) + "\n" + str);
    } 
    splitString();
    if (this.lstStrings.size() * 15 + 6 > getHeight()) {
      getScrollBar().setSize(getScrollBar().getMaxSize() * getHeight() / (this.lstStrings.size() * 15 + 6));
    } else {
      getScrollBar().setSize(getScrollBar().getMaxSize());
    }
    getScrollBar().setPosition(getScrollBar().getMaxSize() - getScrollBar().getSize());
  }

  public void setText(String s) {
    super.setText(s);
    splitString();
  }

  public void clear() {
    super.clear();
    this.lstStrings = new ArrayList<String>();
  }

  public boolean handleEvent(MouseEvent e) {
    if (!getScrollBar().handleEvent(e)) {
      return false;
    }
    if (e.getY() < getY() + getWidth()) {
      changeTextStart(-30);
    } else if (getY() + getHeight() - getWidth() < e.getY()) {
      changeTextStart(30);
    }
    return true;
  }

  public void handleEvent(KeyEvent e) {
    if (!this.active) {
      return;
    }
    super.handleEvent(e);
    splitString();
    if (this.lstStrings.size() * 15 + 6 > getHeight()) {
      getScrollBar().setSize(getScrollBar().getMaxSize() * getHeight() / (this.lstStrings.size() * 15 + 6));
    } else {
      getScrollBar().setSize(getScrollBar().getMaxSize());
    }
    getScrollBar().setPosition(getScrollBar().getMaxSize() - getScrollBar().getSize());
  }

  private void changeTextStart(int increment) {
    setTextStart(getTextStart() + increment);
    if (this.lstStrings.size() * 15 + 6 > getHeight() && getTextStart() >= this.lstStrings.size() * 15 + 6 - getHeight()) {
      setTextStart(this.lstStrings.size() * 15 + 6 - getHeight());
      getScrollBar().setPosition(getScrollBar().getMaxSize() - getScrollBar().getSize());
    } else if (getTextStart() < 0 || this.lstStrings.size() * 15 + 6 <= getHeight()) {
      setTextStart(0);
      getScrollBar().setPosition(0);
    } else {
      getScrollBar().setPosition(getTextStart() * getScrollBar().getMaxSize() / (this.lstStrings.size() * 15 + 6));
    }
  }

  private void splitString() {
    String drawnString = getText();
    ArrayList<String> lstTemp = new ArrayList<String>();
    do {
      int x = 0, lastSpace = -1;
      while (x < drawnString.length() && this.metrics.stringWidth(drawnString.substring(0, x + 1)) <= getWidth() - 10 && !drawnString.substring(x, x + 1).equals("\n")) {
        if (drawnString.charAt(x) == ' ') {
          lastSpace = x;
        }
        x++;
      }
      int xReal = x;
      if (lastSpace > 0 && drawnString.length() > x) {
        x = lastSpace + 1;
      }
      if (drawnString.length() > xReal && drawnString.substring(xReal, xReal + 1).equals("\n")) {
        lstTemp.add(drawnString.substring(0, xReal));
        drawnString = drawnString.substring(xReal + 1);
      } else {
        lstTemp.add(drawnString.substring(0, x));
        drawnString = drawnString.substring(x);
      }
    } while (this.metrics.stringWidth(drawnString) > 0);
    if (lstTemp.size() * 15 - getHeight() + 6 > 0) {
      setTextStart(lstTemp.size() * 15 - getHeight() + 6);
    } else {
      setTextStart(0);
    }
    this.lstStrings = lstTemp;
  }

  public void draw(Graphics g) {
    GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
    GraphicsDevice device = env.getDefaultScreenDevice();
    GraphicsConfiguration gc = device.getDefaultConfiguration();
    BufferedImage source = gc.createCompatibleImage(getWidth(), getHeight());
    Graphics2D srcGraphics = source.createGraphics();
    if (isSelected() && System.currentTimeMillis() - getLastCursorChange() > getBlinkInterval()) {
      if (getCursorState() == 0) {
        setCursorState(1);
      } else {
        setCursorState(0);
      }
      setLastCursorChange(System.currentTimeMillis());
    }
    srcGraphics.setColor(Color.green);
    srcGraphics.setFont(getFont());
    int x;
    for (x = 0; x < this.lstStrings.size(); x++) {
      srcGraphics.drawString(this.lstStrings.get(x), 5, this.metrics.getHeight() + x * 15 - getTextStart());
    }
    x--;
    if (isSelected() && getCursorState() == 1) {
      srcGraphics.drawLine(this.metrics.stringWidth(this.lstStrings.get(x)) + 6, 5 + x * 15 - getTextStart(), this.metrics.stringWidth(this.lstStrings.get(x)) + 6, this.metrics.getHeight() + x * 15 - getTextStart());
    }
    g.setColor(Color.green);
    g.setFont(getFont());
    g.drawImage(source, getX(), getY(), null);
    g.drawString(getLabel(), getX() - this.metrics.stringWidth(getLabel()) - 10, getY() + (getHeight() + this.metrics.getHeight()) / 2 - 2);
    g.setColor(Color.red);
    if (!this.noBorder) {
      g.drawRect(getX(), getY(), getWidth(), getHeight());
    }
    if (getScrollBar() != null) {
      getScrollBar().draw(g);
    }
  }
}
