package gamegui;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public class Animation extends Member {

  public ArrayList<BufferedImage> frames;
  public long drawInterval;
  public boolean wrap;

  int currentFrame;
  long lastFrameChange;
  boolean reachedEnd;

  public Animation(String newName, int newX, int newY, int newWidth, int newHeight, int newInterval, boolean wrap) {
    super(newName, newX, newY, newWidth, newHeight);
    this.frames = new ArrayList<BufferedImage>();
    this.currentFrame = 0;
    this.drawInterval = newInterval;
    this.lastFrameChange = 0L;
    this.reachedEnd = false;
    this.wrap = wrap;
  }

  public Animation(Animation copy) {
    super(copy.getName(), copy.getX(), copy.getY(), copy.getWidth(), copy.getHeight());
    this.frames = copy.frames;
    this.currentFrame = copy.currentFrame;
    this.drawInterval = copy.drawInterval;
    this.lastFrameChange = 0L;
    this.reachedEnd = false;
    this.wrap = copy.wrap;
  }

  public void addFrame(BufferedImage newFrame) {
    this.frames.add(newFrame);
    setWidth(newFrame.getWidth());
    setHeight(newFrame.getHeight());
  }

  public void draw(Graphics g) {
    if (this.lastFrameChange == 0L)
      this.lastFrameChange = System.currentTimeMillis(); 
    if (System.currentTimeMillis() - this.lastFrameChange > this.drawInterval) {
      this.currentFrame++;
      if (this.currentFrame >= this.frames.size()) {
        if (this.wrap) {
          this.currentFrame = 0;
        } else {
          this.currentFrame--;
        }
        this.reachedEnd = true;
      }
      this.lastFrameChange = System.currentTimeMillis();
    }
    g.drawImage(this.frames.get(this.currentFrame), getX(), getY(), null);
  }

  public void draw(Graphics g, int x, int y) {
    if (this.lastFrameChange == 0L)
      this.lastFrameChange = System.currentTimeMillis(); 
    if (System.currentTimeMillis() - this.lastFrameChange > this.drawInterval) {
      this.currentFrame++;
      if (this.currentFrame >= this.frames.size()) {
        if (this.wrap) {
          this.currentFrame = 0;
        } else {
          this.currentFrame--;
        }
        this.reachedEnd = true;
      }
      this.lastFrameChange = System.currentTimeMillis();
    }
    g.drawImage(this.frames.get(this.currentFrame), getX() + x - ((BufferedImage)this.frames.get(this.currentFrame)).getWidth() / 2, getY() + y - ((BufferedImage)this.frames.get(this.currentFrame)).getHeight(), null);
  }

  public boolean reachedEnd() {
    return this.reachedEnd;
  }

  public void reset() {
    this.reachedEnd = false;
    this.currentFrame = 0;
    this.lastFrameChange = 0L;
  }

  public int getWidth() {
    return ((BufferedImage)this.frames.get(this.currentFrame)).getWidth();
  }

  public int getHeight() {
    return ((BufferedImage)this.frames.get(this.currentFrame)).getHeight();
  }
}
