#version 410

uniform mat4 view, proj;

layout(location = 0) in vec3 vertex_position;
layout(location = 1) in vec3 vertex_color;

out vec3 position_eye, color;

void main() {
  position_eye = vec3(view * vec4(vertex_position, 1.0));
  color = vertex_color;

  gl_Position = proj * vec4(position_eye, 1.0);
}