#include <SDL2/SDL.h>
#include <SDL2/SDL_vulkan.h>

#define _USE_MATH_DEFINES // Will be needed when/if I need to # include <cmath>

#define GLM_FORCE_RADIANS
#define GLM_FORCE_DEPTH_ZERO_TO_ONE
#include <glm/vec4.hpp>
#include <glm/mat4x4.hpp>

#include <iostream>
#include <vector>

using namespace std;
using namespace glm;

const int SCREEN_WIDTH = 800;
const int SCREEN_HEIGHT = 600;

int main(int argc, char* argv[]) {
   cout << "Starting Vulkan SDL game..." << endl;

   SDL_Window* window = nullptr;
   //SDL_Surface* screenSurface = nullptr;

   if (SDL_Init(SDL_INIT_VIDEO) < 0) {
      cout << "SDL could not initialize! SDL_Error: " << SDL_GetError() << endl;
   } else {
      window = SDL_CreateWindow("Vulkan Game",
                  SDL_WINDOWPOS_CENTERED, SDL_WINDOWPOS_CENTERED,
                  SCREEN_WIDTH, SCREEN_HEIGHT,
		  SDL_WINDOW_VULKAN);

      if (window == nullptr) {
         cout << "Window could not be created! SDL_Error: " << SDL_GetError() << endl;
      } else {
         //screenSurface = SDL_GetWindowSurface(window);

         //SDL_FillRect(screenSurface, nullptr, SDL_MapRGB(screenSurface->format, 0xFF, 0xFF, 0xFF));
            
         SDL_UpdateWindowSurface(window);

	 uint32_t extensionCount;
   
	 //vkEnumerateInstanceExtensionProperties(nullptr, &extensionCount, nullptr);

	 //cout << "Vulkan extensions (" << extensionCount << "):" << endl;
         //cout << endl;

         SDL_Vulkan_GetInstanceExtensions(window, &extensionCount, nullptr);

         vector<const char*> extensionNames(extensionCount);
         SDL_Vulkan_GetInstanceExtensions(window, &extensionCount, extensionNames.data());

	 cout << "SDL Vulkan extensions (" << extensionCount << "):" << endl;

	 for (vector<const char*>::iterator it = extensionNames.begin(); it != extensionNames.end(); it++) {
            cout << *it << endl;
         }

         SDL_Delay(2000);
      }
   }

   SDL_DestroyWindow( window );

   SDL_Quit();

   cout << "Finished" << endl;

   exit(0);
}
