#version 410 core

// TODO: Pass the explosion center in as a uniform

uniform float explosion_start_time;
uniform float cur_time;

layout (location = 0) in vec3 v_i; // initial velocity
layout (location = 1) in float start_time;

out float opacity;

void main() {
   float duration = 0.5;
   float t = cur_time - explosion_start_time - start_time;

   if (t < 0.0) {
      opacity = 0.0;
   } else {
      // Need to find out the last time this particle was at the origin
      // If that is greater than the duration, hide the particle
      float cur = floor(t / duration);
      float end = floor((duration - start_time) / duration);
      if (cur > end) {
         opacity = 0.0;
      } else {
         opacity = 1.0 - (t / duration);
      }
   }

   vec3 p = vec3(0.0, 0.0, 0.0); //  this is the center of the explosion
   vec3 a = vec3(0.0, 0.1, 0.0);
   p += normalize(v_i) * mod(t, duration) / duration * 0.3; // allow time to loop around so particle emitter keeps going

   gl_Position = vec4(p, 1.0);
   gl_PointSize = 15.0; // size in pixels
}
