#include <iostream>

#include "consts.hpp"
#include "crash-logger.hpp"

#include "vulkan-game.hpp"

using namespace std;

int __main(int argc, char* argv[]);

int main(int argc, char* argv[]) {
   // TODO: Add date & time to the crash log
   CrashLogger logger(__main, argc, argv);

   exit(0);
}

int __main(int argc, char* argv[]) {
   const int MAX_FRAMES_IN_FLIGHT = 2;

   cout << "Starting Vulkan Game..." << endl;

   VulkanGame game(MAX_FRAMES_IN_FLIGHT);

   try {
      game.run(800, 600, GUI_FLAGS_WINDOW_FULLSCREEN);
   } catch (const exception& e) {
      cerr << e.what() << endl;
      return EXIT_FAILURE;
   }

   cout << "Finished running the game" << endl;

   return EXIT_SUCCESS;
}
