#version 450
#extension GL_ARB_separate_shader_objects : enable

// TODO: Figure out if the UniformBufferObject label is necessary and, if not, remove it
layout (binding = 0) uniform UniformBufferObject {
   mat4 model;
   mat4 view;
   mat4 proj;
} ubo;

layout(location = 0) in vec3 vertex_position;
layout(location = 1) in vec3 vertex_color;
//layout(location = 2) in vec3 vertex_normal;
//layout(location = 3) in uint ubo_index;

//out vec3 position_eye, normal_eye, color, light_position_eye, light2_position_eye;
layout(location = 0) out vec3 position_eye;
layout(location = 1) out vec3 color;
layout(location = 2) out vec3 light_position_eye;
layout(location = 3) out vec3 light2_position_eye;

// fixed point light position
vec3 light_position_world = vec3(0.0, 0.0, 2.0);
vec3 light2_position_world = vec3(0.0, 1.5, -0.1);

void main() {
   //position_eye = vec3(view * model_mats[ubo_index] * vec4(vertex_position, 1.0));
   position_eye = vec3(ubo.view * ubo.model * vec4(vertex_position, 1.0));
   //normal_eye = normalize(vec3(view * model_mats[ubo_index] * vec4(vertex_normal, 0.0)));
   color = vertex_color;
   light_position_eye = vec3(ubo.view * vec4(light_position_world, 1.0));
   light2_position_eye = vec3(ubo.view * vec4(light2_position_world, 1.0));

   gl_Position = ubo.proj * vec4(position_eye, 1.0);
}
