#include "opengl-game.hpp"

#include <iostream>

#include "consts.hpp"
#include "logger.hpp"

using namespace std;

OpenGLGame::OpenGLGame() {
   gui = nullptr;
   window = nullptr;
}

OpenGLGame::~OpenGLGame() {
}

void OpenGLGame::run(int width, int height, unsigned char guiFlags) {
#ifdef NDEBUG
   cout << "DEBUGGING IS OFF" << endl;
#else
   cout << "DEBUGGING IS ON" << endl;
#endif

   cout << "OpenGL Game" << endl;

   // TODO: Refactor the logger api to be more flexible,
   // esp. since gl_log() and gl_log_err() have issues printing anything besides stirngs
   restart_gl_log();
   gl_log("starting GLFW\n%s", glfwGetVersionString());

   open_log();
   get_log() << "starting GLFW" << endl;
   get_log() << glfwGetVersionString() << endl;

   if (initWindow(width, height, guiFlags) == RTWO_ERROR) {
      return;
   }

   initOpenGL();
   mainLoop();
   cleanup();

   close_log();
}

// TODO: Make some more initi functions, or call this initUI if the
// amount of things initialized here keeps growing
bool OpenGLGame::initWindow(int width, int height, unsigned char guiFlags) {
   // TODO: Put all fonts, textures, and images in the assets folder
   gui = new GameGui_GLFW();

   if (gui->init() == RTWO_ERROR) {
      // TODO: Also print these sorts of errors to the log
      cout << "UI library could not be initialized!" << endl;
      cout << gui->getError() << endl;
      return RTWO_ERROR;
   }
   cout << "GUI init succeeded" << endl;

   window = (GLFWwindow*) gui->createWindow("OpenGL Game", width, height, guiFlags & GUI_FLAGS_WINDOW_FULLSCREEN);
   if (window == nullptr) {
      cout << "Window could not be created!" << endl;
      cout << gui->getError() << endl;
      return RTWO_ERROR;
   }

   cout << "Target window size: (" << width << ", " << height << ")" << endl;
   cout << "Actual window size: (" << gui->getWindowWidth() << ", " << gui->getWindowHeight() << ")" << endl;

   return RTWO_SUCCESS;
}

void OpenGLGame::initOpenGL() {
}

void OpenGLGame::mainLoop() {
   UIEvent e;
   bool quit = false;

   while (!quit) {
      gui->processEvents();

      while (gui->pollEvent(&e)) {
         switch (e.type) {
            case UI_EVENT_QUIT:
               cout << "Quit event detected" << endl;
               quit = true;
               break;
            case UI_EVENT_KEY:
               if (e.key.keycode == GLFW_KEY_ESCAPE) {
                  quit = true;
               } else {
                  cout << "Key event detected" << endl;
               }
               break;
            default:
               cout << "Unhandled UI event: " << e.type << endl;
         }
      }

      glfwSwapBuffers(window);
   }
}

void OpenGLGame::cleanup() {
   gui->destroyWindow();
   gui->shutdown();
   delete gui;
}