package com.example.helloandroid;
import java.net.*;
import java.io.*;


/*
 * This class serves as a basis for the threads that the other projects use to listen to incoming messages over a network. The most important
 * method, run, initializes a connection based on the constructor arguments and calls different methods depending on the result, which could
 * range from a successful connection, to an unsuccessful one, to one that gets interrupted later on. Any class inheriting this one simply
 * has to extend the methods called in run and the processMessage method to customize the behavior in different situations.
 */

public class Connection extends Thread {
	private boolean connected;
	private boolean interrupted;
	private String ip;
	private int port;
    private Socket socket;
    private PrintWriter out;
    private BufferedReader in;

    public Connection(String ip, int port, String threadName) {
    	super(threadName);
    	
    	connected = false;
    	interrupted = false;
    	socket = null;
    	this.ip = ip;
    	this.port = port;
    }
    
    public Connection(Socket socket, String threadName) {
    	super(threadName);
    	
    	connected = false;
    	interrupted = false;
    	this.socket = socket;
    }
    
    public static boolean isConnected(Connection obj) {
    	return obj != null && obj.connected;
    }
    
    protected PrintWriter getOut() {
    	return out;
    }
    
    protected BufferedReader getIn() {
    	return in;
    }
    
    public void interrupt() {
    	interrupted = true;
    }
    
    public void closeConnection() {
    	try {
    		if(connected) {
    			connected = false;
	    		socket.close();
		    	out.close();
		    	in.close();
    		}
    	} catch(IOException ioe) {
    		ioe.printStackTrace();
    	}
    }
    
    protected void sendMessage(MessageType type, String input) {
		out.println(type);
		out.println(input);
    }
    
    protected void processMessage(MessageType type, String input) {
    	
    }
    
    protected void connectionStart() {
    	
    }
    
    protected void connectionSuccess() {
    	
    }
    
    protected void connectionFailure(String str) {
    	
    }
    
    protected void connectionBreak() {
    	
    }
    
    protected void peerDisconnect() {
    	
    }
    
    protected void connectionEnd() {
    	
    }
    
    public void run() {
    	String strType, str;
    	
    	try {
    		connectionStart();
    		if(socket == null) {
    			connectionFailure("about to make new socket");
    			socket = new Socket(ip, port);
    		}
    		connectionFailure("made new socket");
    		if(!interrupted) {
    			out = new PrintWriter(socket.getOutputStream(), true);
    			in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            	connected = true;
            	connectionSuccess();
    		}
    		connectionFailure("end of connection");
    	}catch(UnknownHostException uhe) {
    		if(!interrupted)
    			connectionFailure("UnknownHostException");
    	}catch(ConnectException ce) {
    		if(!interrupted)
    			connectionFailure("ConnectException");
    	}catch(IOException ioe) {
    		if(!interrupted)
    			ioe.printStackTrace();
    		connectionFailure("IOException");
    	}catch(Exception e) {
    		connectionFailure("Exception");
    	}catch(Throwable e) {
    		connectionFailure("Throwable");
    	}
    	connectionFailure("finished connection");
    	
    	if(interrupted)
    		closeConnection();
    		
    	try{
    		while(connected && (strType = in.readLine()) != null && (str = in.readLine()) != null) {
	    		processMessage(MessageType.valueOf(strType), str);
	    	}
    		if(connected)
    			peerDisconnect();
		}catch(SocketException se) {
			if(connected)
				connectionBreak();
		}catch(IOException ioe) {
			ioe.printStackTrace();
		}

		closeConnection();
		connectionEnd();
	}
}
