package main;

import java.awt.image.BufferedImage;

public class RespawnPoint extends Structure {

  private boolean marked;

  public RespawnPoint(StructureType type, BufferedImage img) {
    super(type, img, true);
    this.marked = false;
  }

  public RespawnPoint(StructureType type, String imgFile, boolean passable) {
    super(type, imgFile, passable);
    this.marked = false;
  }

  public RespawnPoint(RespawnPoint copy, Point loc) {
    super(copy, loc);
    this.marked = copy.marked;
  }

  public boolean isMarked() {
    return this.marked;
  }

  public void mark() {
    this.marked = true;
  }

  public void unmark() {
    this.marked = false;
  }
}
