package main;

public class MoveSpeed extends TimedEffect {

  private double speedChange;
  private int oldSpeed;
  private boolean frozen;
  
  public MoveSpeed(double speedChange, TargetType target, long duration) {
    super(EffectType.MoveSpeed, target, duration);
    this.speedChange = speedChange;
    this.frozen = (speedChange == 0.0D);
  }

  public MoveSpeed(MoveSpeed e) {
    super(e);
    this.speedChange = e.speedChange;
  }

  public MoveSpeed copy() {
    return new MoveSpeed(this);
  }

  public double getSpeedChange() {
    return this.speedChange;
  }

  public void applyEffect(Object o) {
    Creature cr = (Creature)o;
    if (this.frozen) {
      this.oldSpeed = cr.getSpeed();
    }
    cr.setSpeed((int)(cr.getSpeed() * this.speedChange));
    cr.addEffect(this);
    cr.thorns++;
  }

  public void cancelEffect(Object o) {
    Creature cr = (Creature)o;
    if (this.frozen) {
      cr.setSpeed(this.oldSpeed);
    } else {
      cr.setSpeed((int)(cr.getSpeed() / this.speedChange));
    }
    cr.thorns--;
  }

  public String toString() {
    return Double.toString(this.speedChange);
  }
}
