package main;

import java.util.Iterator;

public class AreaOfEffect extends Effect {

  private Effect effect;
  private int range;
  
  public AreaOfEffect(Effect effect, int range, TargetType target) {
    super(EffectType.AreaOfEffect, target);
    this.effect = effect;
    this.range = range;
  }
  
  public AreaOfEffect(AreaOfEffect e) {
    super(e);
    this.effect = e.effect.copy();
    this.range = e.range;
  }
  
  public AreaOfEffect copy() {
    return new AreaOfEffect(this);
  }
  
  public Effect getEffect() {
    return this.effect;
  }
  
  public void applyEffect(Object o) {
    Creature cr = (Creature)o;
    Map map = LostHavenRPG.map;
    for (int x = 0; x < map.getLength(); x++) {
      for (int y = 0; y < map.getHeight(); y++) {
        Iterator<Creature> iter = map.getLoc(x, y).getCreatures().iterator();
        while (iter.hasNext()) {
          Creature temp = iter.next();
          if (Point.dist(temp.getLoc(), cr.getLoc()) <= this.range)
            this.effect.applyEffect(temp); 
        } 
      } 
    } 
  }
}
