package main;

import java.awt.image.BufferedImage;

public class Structure extends MapElement {

  private StructureType type;
  private Point loc;

  public Structure(StructureType type, BufferedImage img, boolean passable) {
    super(img, passable);
    this.type = type;
    this.loc = null;
  }

  public Structure(StructureType type, String imgFile, boolean passable) {
    super(imgFile, passable);
    this.type = type;
    this.loc = null;
  }

  public Structure(Structure copy, Point loc) {
    super(copy);
    this.type = copy.type;
    this.loc = loc;
  }

  public StructureType getType() {
    return this.type;
  }

  public Point getLoc() {
    return this.loc;
  }
}
