package main;

public class Gem extends Item {

  private int value;
  private Effect effect;

  public Gem(String name, String img, int value, Effect effect) {
    super(name, ItemType.Gem, "Gems/" + img);
    this.value = value;
    this.effect = effect;
  }

  public Gem(Gem copy, Point loc) {
    super(copy, loc);
    this.value = copy.value;
    this.effect = copy.effect;
  }

  public Gem copy(Point loc) {
    return new Gem(this, loc);
  }

  public int getValue() {
    return this.value;
  }

  public Effect getEffect() {
    return this.effect;
  }
}
