package gamegui;

import java.awt.*;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;

public class Textbox extends Member {

  private String label;  
  private String text;
  private Font font;
  private int textStart;
  private boolean selected;
  private int cursorState;
  private int blinkInterval;
  private long lastCursorChange;
  private boolean password;
  protected boolean noBorder;

  public Textbox(String newName, int newX, int newY, int newWidth, int newHeight, String newLabel, Font newFont, boolean isPass) {
    super(newName, newX, newY, newWidth, newHeight);
    this.label = new String(newLabel);
    this.text = new String();
    this.font = newFont;
    this.textStart = 0;
    this.selected = false;
    this.cursorState = 0;
    this.blinkInterval = 500;
    this.password = isPass;
    this.noBorder = false;
  }

  public void setBorder(boolean b) {
    this.noBorder = !b;
  }

  public void handleEvent(KeyEvent e) {
    if (32 <= e.getKeyCode() && e.getKeyCode() <= 127) {
      if (e.getKeyCode() == 127) {
        if (this.text.length() > 0) {
          this.text = this.text.substring(0, this.text.length() - 1);
        }
      } else {
        this.text = String.valueOf(this.text) + Character.toString(e.getKeyChar());
      }
    } else if (e.getKeyCode() == 8) {
      if (this.text.length() > 0) {
        this.text = this.text.substring(0, this.text.length() - 1);
      }
    }
  }

  public void draw(Graphics g) {
    String drawnString = new String();
    FontMetrics metrics = g.getFontMetrics(this.font);
    GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
    GraphicsDevice device = env.getDefaultScreenDevice();
    GraphicsConfiguration gc = device.getDefaultConfiguration();
    BufferedImage source = gc.createCompatibleImage(getWidth(), getHeight());
    Graphics2D srcGraphics = source.createGraphics();
    if (this.selected && System.currentTimeMillis() - this.lastCursorChange > this.blinkInterval) {
      if (this.cursorState == 0) {
        this.cursorState = 1;
      } else {
        this.cursorState = 0;
      }
      this.lastCursorChange = System.currentTimeMillis();
    }
    if (this.password) {
      for (int x = 0; x < this.text.length(); x++) {
        drawnString = String.valueOf(drawnString) + "*";
      }
    } else {
      drawnString = this.text;
    }
    if (metrics.stringWidth(drawnString) + 9 > getWidth()) {
      this.textStart = metrics.stringWidth(drawnString) + 9 - getWidth();
    } else {
      this.textStart = 0;
    }
    g.setColor(Color.green);
    g.setFont(this.font);
    srcGraphics.setColor(Color.green);
    srcGraphics.setFont(this.font);
    srcGraphics.drawString(drawnString, 5 - this.textStart, (getHeight() + metrics.getHeight()) / 2 - 2);
    g.drawImage(source, getX(), getY(), null);
    g.drawString(this.label, getX() - metrics.stringWidth(this.label) - 10, getY() + (getHeight() + metrics.getHeight()) / 2 - 2);
    if (this.selected && this.cursorState == 1) {
      g.drawLine(getX() + metrics.stringWidth(drawnString) - this.textStart + 6, getY() + 5, getX() + metrics.stringWidth(drawnString) - this.textStart + 6, getY() + getHeight() - 5);
    }
    g.setColor(Color.red);
    if (!this.noBorder) {
      g.drawRect(getX(), getY(), getWidth(), getHeight());
    }
  }

  public boolean isClicked(int xCoord, int yCoord) {
    if (xCoord < getX() || getX() + getWidth() < xCoord) {
      return false; 
    }
    if (yCoord < getY() || getY() + getHeight() < yCoord) {
      return false; 
    }
    return true;
  }

  public void clear() {
    this.text = "";
    this.textStart = 0;
    this.selected = false;
  }

  public int getBlinkInterval() {
    return this.blinkInterval;
  }

  public int getCursorState() {
    return this.cursorState;
  }

  public Font getFont() {
    return this.font;
  }

  public String getLabel() {
    return this.label;
  }

  public long getLastCursorChange() {
    return this.lastCursorChange;
  }

  public boolean isSelected() {
    return this.selected;
  }

  public String getText() {
    return this.text;
  }

  public int getTextStart() {
    return this.textStart;
  }

  public void setText(String newText) {
    this.text = newText;
  }

  public void setSelected(boolean isSelected) {
    this.selected = isSelected;
  }

  public void setTextStart(int textStart) {
    this.textStart = textStart;
  }

  public void setCursorState(int cursorState) {
    this.cursorState = cursorState;
  }

  public void setLastCursorChange(long lastCursorChange) {
    this.lastCursorChange = lastCursorChange;
  }
}
